<?php

/* ***********
    Duplicate for page, post, custom post type as single item
************ */


// Add duplicate post link to post and page row actions
function add_duplicate_post_mycodecare_post_link($actions, $post)
{
    $duplicate_post_mycodecare_button_text = (get_option('duplicate_post_button_text')) ? (get_option('duplicate_post_button_text')) : ('Duplicate');

    if (current_user_can('edit_posts') && get_post_type($post->ID) == 'post' || get_post_type($post->ID) == 'page') {
        $actions['duplicate_post'] = '<a href="' . esc_url(wp_nonce_url(admin_url('admin.php?action=duplicate_post&amp;post='
                . $post->ID), 'duplicate-post_' . $post->ID)) . '" title="'
            . __('Duplicate this item', 'duplicate-page-post-mcc') . '" rel="permalink">
            <span class="dashicons dashicons-admin-page"></span> ' . esc_html($duplicate_post_mycodecare_button_text) .'</a>';
    }
    elseif (current_user_can('edit_posts') && get_post_type($post->ID) != 'post' || !get_post_type($post->ID) != 'page'){
        $actions['duplicate_post'] = '<a style="color: black; background: #FFD700; border-radius: 5px; padding: 1px 5px 2px 5px;" href="https://mycodecare.com/duplicate-page-plugin/" target="_blank">Buy Duplicate page, post -MMC for access.</a>';
    }
    return $actions;
}

add_filter('post_row_actions', 'add_duplicate_post_mycodecare_post_link', 10, 2);
add_filter('page_row_actions', 'add_duplicate_post_mycodecare_post_link', 10, 2);


// Duplicate post functionality
function duplicate_post_mycodecare_action()
{
    if (isset($_GET['action']) && sanitize_text_field(wp_unslash($_GET['action'])) == 'duplicate_post') {

        if (isset($_GET['post']) && !empty(sanitize_text_field(wp_unslash($_GET['post'])))) {
            $post_id = absint(sanitize_text_field(wp_unslash($_GET['post'])));

            if (current_user_can('edit_posts') && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])),
                    'duplicate-post_' . $post_id)) {
                $post = get_post($post_id);

//                if (isset($submit)&& ($post) && !empty($post)) {
                if ($post && !empty($post) && get_post_type($post->ID) == 'post' || get_post_type($post->ID) == 'page') {
                    $mycodecare_duplicate_post_status = (get_option('duplicate_post_status')) ? (get_option('duplicate_post_status')) : ('draft');

                    $mycodecare_duplicate_prefix_get = get_option('duplicate_post_prefix_text');
                    $mycodecare_duplicate_suffix_get = get_option('duplicate_post_suffix_text');

                    $new_post_args = array(
                        'post_title' => $mycodecare_duplicate_prefix_get . ' ' . sanitize_text_field($post->post_title) . ' ' . $mycodecare_duplicate_suffix_get,
                        'post_content' => wp_kses_post($post->post_content),
                        'post_status' => $mycodecare_duplicate_post_status, // Set the post status to draft
                        'post_type' => $post->post_type,
                    );
                    $new_post_id = wp_insert_post($new_post_args);
                    if ($new_post_id) {
                        // Duplicate post meta
                        $post_meta = get_post_meta($post_id);
                        foreach ($post_meta as $key => $values) {
                            foreach ($values as $value) {
                                add_post_meta($new_post_id, $key, sanitize_text_field($value));
                            }
                        }
                        // Redirect to the post list page with success notice
                        wp_safe_redirect(admin_url('edit.php?post_type=' . $post->post_type . '&duplicate_success=1'));
                        exit;
                    } else {
                        // Error: Unable to duplicate post
                        add_action('admin_notices', 'duplicate_post_error_notice');
                        exit;
                    }
                }

            }
        }
    }
}

add_action('admin_init', 'duplicate_post_mycodecare_action');

