<?php

/**
 * Plugin Name:       Duplicate Page Post – MCC
 * Plugin URI:        https://wordpress.org/plugins/duplicate-page-post-mcc/
 * Description:       Easily duplicate posts, pages, and custom post types to streamline your workflow.
 * Version:           1.10.1
 * Requires at least: 4.6
 * Requires PHP:      5.0.0
 * Author:            MyCodeCare
 * Author URI:        https://mycodecare.com/
 * License:           GPLv3
 * License URI:       https://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain:       duplicate-page-post-mcc
 *
 */
if ( !defined( 'ABSPATH' ) ) {
    die( 'You cannot jump here!!' );
}
if ( function_exists( 'dpm_fs' ) ) {
    dpm_fs()->set_basename( false, __FILE__ );
} else {
    if ( !function_exists( 'dpm_fs' ) ) {
        function dpm_fs() {
            global $dpm_fs;
            if ( !isset( $dpm_fs ) ) {
                // Include Freemius SDK.
                require_once dirname( __FILE__ ) . '/freemius/start.php';
                $dpm_fs = fs_dynamic_init( array(
                    'id'             => '15710',
                    'slug'           => 'duplicate-post-mycodecare',
                    'type'           => 'plugin',
                    'public_key'     => 'pk_724716e6937096a222b913269b273',
                    'is_premium'     => false,
                    'premium_suffix' => 'Pro',
                    'has_addons'     => false,
                    'has_paid_plans' => true,
                    'menu'           => array(
                        'slug'       => 'duplicate-post-mycodecare-menu',
                        'first-path' => 'admin.php?page=duplicate-post-mycodecare-menu',
                        'support'    => false,
                    ),
                    'is_live'        => true,
                ) );
            }
            return $dpm_fs;
        }

        // Init Freemius.
        dpm_fs();
        // Signal that SDK was initiated.
        do_action( 'dpm_fs_loaded' );
    }
    require_once plugin_dir_path( __FILE__ ) . 'features/duplicate/page-post.php';
    // Admin notice
    require_once plugin_dir_path( __FILE__ ) . 'features/admin-notice.php';
    // Enqueue JavaScript only for the specified page slug
    function duplicate_post_mycodecare_enqueue_scripts() {
        // Check if we are on the options page and the page slug matches
        if ( isset( $_GET['page'] ) && $_GET['page'] == 'duplicate-post-mycodecare-menu' ) {
            wp_enqueue_script(
                'duplicate-post-mycodecare-main-js',
                plugins_url( '/assets/js/main.js', __FILE__ ),
                array('jquery'),
                '1.0',
                true
            );
            // Enqueue your custom JavaScript file
            wp_enqueue_script(
                'datatable-script',
                plugins_url( '/assets/datatable/datatables.min.js', __FILE__ ),
                array('jquery'),
                '1.0',
                true
            );
            wp_enqueue_style(
                'datatable-style',
                plugin_dir_url( __FILE__ ) . '/assets/datatable/datatables.min.css',
                array(),
                '1.0'
            );
            wp_enqueue_style(
                'datatable-style',
                plugin_dir_url( __FILE__ ) . '/assets/sweet-alert.min.css',
                array(),
                '1.0'
            );
            wp_enqueue_script(
                'duplicate-posts-script',
                plugin_dir_url( '/assets/js/duplicate-posts.js', __FILE__ ),
                array('jquery'),
                '1.0',
                true
            );
            wp_localize_script( 'duplicate-posts-script', 'duplicate_posts_ajax_object', array(
                'ajax_url' => admin_url( 'admin-ajax.php' ),
                'security' => wp_create_nonce( 'duplicate-posts-security' ),
            ) );
        }
    }

    add_action( 'admin_enqueue_scripts', 'duplicate_post_mycodecare_enqueue_scripts' );
    if ( !function_exists( 'duplicate_post_mycodecare_custom_admin_menu' ) ) {
        function duplicate_post_mycodecare_custom_admin_menu() {
            add_menu_page(
                'Duplicate Page Post – MCC',
                // Page title
                'Duplicate – MCC',
                // Menu title
                'manage_options',
                // Capability
                'duplicate-post-mycodecare-menu',
                // Menu slug
                'duplicate_post_mycodecare_admin_menu_page',
                // Callback function
                'dashicons-controls-repeat',
                // Icon URL
                20
            );
        }

    }
    if ( !function_exists( 'duplicate_post_mycodecare_admin_menu_page' ) ) {
        function duplicate_post_mycodecare_admin_menu_page() {
            if ( !current_user_can( 'manage_options' ) ) {
                wp_die( 'You do not have sufficient permissions to access this page.' );
            }
            if ( isset( $_POST['selected_types'] ) ) {
                update_option( 'selected_post_types_taxonomies', $_POST['selected_types'] );
                echo '<div class="updated"><p>Settings saved.</p></div>';
            }
            $selected_tab = ( isset( $_GET['tab'] ) ? $_GET['tab'] : 'duplicate-post-page-options' );
            $post_types = get_post_types( array(
                'public' => true,
            ), 'objects' );
            $taxonomies = get_taxonomies( array(
                'public' => true,
            ), 'objects' );
            ?>
            <div class="wrap">
                <h2>Duplicate Page Post – MCC</h2>
                <h2 class="nav-tab-wrapper">

                    <a href="?page=duplicate-post-mycodecare-menu&tab=duplicate-post-page-options"
                       class="nav-tab <?php 
            echo ( $selected_tab == 'duplicate-post-page-options' ? 'nav-tab-active' : '' );
            ?>">Duplicate
                        Post/Page Options</a>
                    <a href="?page=duplicate-post-mycodecare-menu&tab=general-settings"
                       class="nav-tab <?php 
            echo ( $selected_tab == 'general-settings' ? 'nav-tab-active' : '' );
            ?>">General
                        Settings</a>

                </h2>

                <div class="tab-content">
                    <?php 
            if ( $selected_tab == 'duplicate-post-page-options' ) {
                ?>

                        <?php 
                require_once plugin_dir_path( __FILE__ ) . 'features/options/page-post-options.php';
                ?>
                    <?php 
            } elseif ( $selected_tab == 'general-settings' ) {
                ?>
                        <?php 
                require_once plugin_dir_path( __FILE__ ) . 'features/options/general-settings.php';
                ?>
                    <?php 
            }
            ?>
                </div>
            </div>
            <?php 
        }

    }
    if ( !function_exists( 'duplicate_post_mycodecare_hook_admin_menu' ) ) {
        add_action( 'admin_menu', 'duplicate_post_mycodecare_custom_admin_menu' );
    }
}
?>

