document.addEventListener('DOMContentLoaded', function () {
    const tabs = document.querySelectorAll('.nav-tab');
    const tabContents = document.querySelectorAll('.tab-content');

    tabs.forEach(tab => {
        tab.addEventListener('click', function () {
            const tabId = this.getAttribute('data-tab');

            tabs.forEach(tab => tab.classList.remove('nav-tab-active'));
            tabContents.forEach(content => content.style.display = 'none');

            this.classList.add('nav-tab-active');
            document.getElementById(tabId).style.display = 'block';
        });

        // Add cursor pointer on hover
        tab.addEventListener('mouseover', function () {
            this.style.cursor = 'pointer';
        });

        tab.addEventListener('mouseout', function () {
            this.style.cursor = 'default';
        });
    });

    // Set default view to "Duplicate Post/Page Options"
    document.getElementById('duplicate-post-page-options').style.display = 'block';
});
