jQuery(document).ready(function($) {
    // Check all checkboxes when the "Select All" checkbox is clicked
    $('#select-all').click(function() {
        $('input[type="checkbox"]').prop('checked', $(this).prop('checked'));
    });

    // Enable/disable the "Duplicate" button based on checkbox selection
    $('input[type="checkbox"]').click(function() {
        var checked = $('input[type="checkbox"]:checked').length > 0;
        $('#duplicate-button').prop('disabled', !checked);
    });

    // AJAX request to duplicate posts
    $('#duplicate-button').click(function() {
        var post_ids = $('input[name="post_ids[]"]:checked').map(function() {
            return this.value;
        }).get();

        $.ajax({
            url: duplicate_posts_ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'duplicate_posts',
                post_ids: post_ids,
                security: duplicate_posts_ajax_object.security,
            },
            success: function(response) {
                $('#duplicate-status').html('<p>' + response.data + '</p>').fadeIn();
                setTimeout(function() {
                    $('#duplicate-status').fadeOut();
                }, 3000);
            },
            error: function(xhr, status, error) {
                console.error(xhr.responseText);
                $('#duplicate-status').html('<p>Error: ' + xhr.responseText + '</p>').fadeIn();
            }
        });
    });
});
