<?php
/**
 * Drop Print Uninstall
 *
 * Uninstalling Drop Print deletes relevant user options and clears scheduled events.
 * It does *not* delete the pricelist.json, uploaded .afp files,
 * the uploads/drop-print directory, or the pa_print_dimensions attribute/terms.
 * It also does *not* delete the _drop_print_meta post meta from products.

 */
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}
$connection_option = 'drop_print_connection_details';
$other_options_to_delete = array(
    'drop_print_packing_slip_attachment_id',
    'drop_print_file_handling',
    'drop_print_price_margin',
    'drop_print_measurement_pref',
    'drop_print_payment_frequency',
    'drop_print_auto_production',
    'drop_print_settings',
    'drop_print_files'
);
delete_option( 'drop_print_settings' );

foreach ( $other_options_to_delete as $option_name ) {
    delete_option( $option_name );
}
wp_clear_scheduled_hook('drop_print_pricelist_sync_hook');
wp_clear_scheduled_hook('drop_print_initial_data_sync_hook');
?>