<?php
/**
 * Drop Print Plugin Activation & Deactivation Functions (v1.1.1).
 * This file handles tasks upon plugin activation, such as checking for WooCommerce
 * dependency, creating the global 'pa_print_dimensions' attribute if it
 * doesn't exist, and initializing the 'drop_print_files' option for tracking
 * Alden Fine Print (.afp) file usage across products.
 * It also sets admin notices to inform the user about these actions and potential manual cleanup
 * required on deactivation Deactivation hook cleans up specific transients.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
function drop_print_plugin_activation() {
	if ( function_exists( 'drop_print_create_global_attribute' ) ) {
		if ( ! drop_print_create_global_attribute( __( 'Print Dimensions', 'drop-print' ), 'print_dimensions' ) ) {
		}
	} else {
		wp_safe_redirect( admin_url( 'plugins.php?error=drop_print_missing_utils' ) );
		exit;
	}
	if ( false === get_option( 'drop_print_files' ) ) {
		update_option( 'drop_print_files', [] );
	}
	// translators: %1$s: Name of a directory (e.g., 'drop_print_pricelist'). %2$s: Name/slug of a component (e.g., 'drop-print'). %3$s: Name of a product attribute (e.g., 'Print Dimensions'). %4$s: Placeholder for an uploads directory name.
	$format_string = __( 'Drop Print has created a %1$s directory in your uploads (if it didn\'t exist), and added a "%2$s" global attribute. Deactivating the plugin does not remove the "%3$s" attribute and the %4$s uploads directory must be manually deleted if desired.', 'drop-print' );
	$notice_message = sprintf(
		$format_string,
		'<code>drop_print_pricelist</code>',
		'<code>drop-print</code>',
		esc_html__( 'Print Dimensions', 'drop-print' ),
		esc_html__( 'Print Dimensions', 'drop-print' )
	);
	set_transient( 'drop_print_activation_notice', $notice_message, 30 );
}
function drop_print_show_activation_notice() {
	if ( $notice_message = get_transient( 'drop_print_activation_notice' ) ) {
		?>
		<div class="notice notice-info is-dismissible">
			<p><?php echo wp_kses_post( $notice_message ); ?></p>
		</div>
		<?php
		delete_transient( 'drop_print_activation_notice' );
	}
    $error_param = isset($_GET['error']) ? sanitize_key($_GET['error']) : '';
	if ( 'drop_print_woocommerce_required' === $error_param ) {
		?>
		<div class="notice notice-error is-dismissible">
			<p><?php esc_html_e( 'The Drop Print Plugin requires WooCommerce to be installed and activated.', 'drop-print' ); ?></p>
		</div>
		<?php
	}
	if ( 'drop_print_attribute_creation_failed' === $error_param ) {
		?>
		<div class="notice notice-error is-dismissible">
			<p><?php esc_html_e( 'Failed to create the "Print Dimensions" attribute. Please ensure WooCommerce is functioning correctly.', 'drop-print' ); ?></p>
		</div>
		<?php
	}
	if ( 'drop_print_missing_utils' === $error_param ) {
		?>
		<div class="notice notice-error is-dismissible">
			<p><?php esc_html_e( 'Drop Print critical file missing (utils.php). Please reinstall the plugin.', 'drop-print' ); ?></p>
		</div>
		<?php
	}
}
add_action( 'admin_notices', 'drop_print_show_activation_notice' );
function drop_print_plugin_deactivate() {
	delete_transient( 'drop_print_activation_notice' );
}