<?php
/**
 * Drop Print Enqueue Scripts and Styles (v1.1.2)
 * Conditionally loads assets for product edit and WooCommerce order list pages.
 * Localizes user-specific data for JavaScript via 'dropPrintData' (for product
 * editing) and 'drop_print_vars' (for order list Drop Print modal),
 * reflecting the current user's settings and connection status.
 */
if(!defined('ABSPATH')){exit;}
function drop_print_enqueue_admin_scripts($hook_suffix){
    $screen = get_current_screen();
    if(!$screen){return;}
    $plugin_version = defined('DROP_PRINT_VERSION') ? DROP_PRINT_VERSION : '1.1.2';
    $current_user_id = get_current_user_id();
    if($current_user_id === 0 && ('product' === $screen->id && 'post' === $screen->base)){return;}
    $user_settings = drop_print_get_user_settings($current_user_id);
    $is_connected_to_dp = !empty($user_settings['client_user_connection_id']);
    if('product' === $screen->id && 'post' === $screen->base && $is_connected_to_dp){
        $product_id = get_the_ID();
        if(!$product_id) return;
        wp_enqueue_style('dashicons');
        wp_enqueue_style('dropzone-css', DROP_PRINT_PLUGIN_URL.'assets/css/dropzone.min.css', array(), '5.9.3');
        wp_enqueue_style('drop-print-admin', DROP_PRINT_PLUGIN_URL.'assets/css/admin.css', array(), filemtime(DROP_PRINT_PLUGIN_PATH.'assets/css/admin.css'));
        wp_enqueue_style('drop-print-products', DROP_PRINT_PLUGIN_URL.'assets/css/products.css', array('drop-print-admin'), filemtime(DROP_PRINT_PLUGIN_PATH.'assets/css/products.css'));
        wp_enqueue_script('dropzone-js', DROP_PRINT_PLUGIN_URL.'assets/js/dropzone.min.js', array(), '5.9.3', true);
        wp_enqueue_script('drop_print_core', DROP_PRINT_PLUGIN_URL.'assets/js/drop-print.js', array('jquery','wp-util','lodash'), filemtime(DROP_PRINT_PLUGIN_PATH.'assets/js/drop-print.js'), true);
        $default_user_settings = drop_print_get_default_user_settings();
        $drop_print_meta = get_post_meta($product_id, '_drop_print_meta', true);
        $drop_print_meta = is_array($drop_print_meta) ? $drop_print_meta : array();
        $wc_currency = function_exists('get_woocommerce_currency') ? get_woocommerce_currency() : 'GBP';
        $wc_symbol = function_exists('get_woocommerce_currency_symbol') ? get_woocommerce_currency_symbol() : '£';
        $wc_unit = get_option('woocommerce_dimension_unit','in');
        $cost_currency_from_settings = $user_settings['billing_currency'] ?? $wc_currency;
        $available_media = $user_settings['available_media'] ?? [];
        $default_media_id_to_use = $user_settings['default_media_id'] ?? $default_user_settings['default_media_id'];
        $is_id_valid = false;
        if(!empty($available_media)){
            $available_media_ids = wp_list_pluck($available_media,'id');
            if(in_array($default_media_id_to_use, $available_media_ids, true)){
                $is_id_valid = true;
            }
            if(!$is_id_valid && !empty($available_media_ids)){
                $fallback_priority = ['hpr-188'];
                if(isset($available_media_ids[0]) && !in_array($available_media_ids[0], $fallback_priority, true)){
                    $fallback_priority[] = $available_media_ids[0];
                }
                foreach($fallback_priority as $fallback_id){
                    if(in_array($fallback_id, $available_media_ids, true)){
                        $default_media_id_to_use = $fallback_id;
                        $is_id_valid = true;
                        break;
                    }
                }
            }
            if(!$is_id_valid && !empty($available_media_ids) && isset($available_media_ids[0])){
                $default_media_id_to_use = $available_media_ids[0];
            }elseif(!$is_id_valid){
                $default_media_id_to_use = $default_user_settings['default_media_id'];
            }
        }else{
            $default_media_id_to_use = $default_user_settings['default_media_id'];
        }
        $default_pricelist_data = null;
        if($default_media_id_to_use){
            $pricelist_file_name = sanitize_key($default_media_id_to_use).".json";
            $pricelist_file_path = trailingslashit(DROP_PRINT_CACHE_DIR).$pricelist_file_name;
            if(file_exists($pricelist_file_path) && is_readable($pricelist_file_path)){
                $json_content = file_get_contents($pricelist_file_path);
                if(false !== $json_content && !empty(trim($json_content))){
                    $decoded_data = json_decode($json_content, true);
                    if(json_last_error() === JSON_ERROR_NONE && is_array($decoded_data) && isset($decoded_data['products'], $decoded_data['media_id'], $decoded_data['media_name'], $decoded_data['currency_code']) && $decoded_data['media_id'] === $default_media_id_to_use){
                        $default_pricelist_data = $decoded_data;
                    }
                }
            }
        }
        $meta_preview_id_val = isset($drop_print_meta['preview_id']) ? absint($drop_print_meta['preview_id']) : 0;
        $max_upload_size_bytes = wp_max_upload_size();
        $max_upload_size_mb = floor($max_upload_size_bytes / (1024 * 1024));
        $localized_data = [
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('drop_print_nonce'),
            'settingsPageUrl' => admin_url('admin.php?page=drop-print-settings'),
            'productId' => $product_id,
            'priceMargin' => (float) ($user_settings['price_margin'] ?? $default_user_settings['price_margin']),
            'wcCurrency' => $wc_currency,
            'wcCurrencySymbol' => $wc_symbol,
            'wcMeasurementUnit' => $wc_unit,
            'metaIsActive' => $drop_print_meta['active'] ?? 'no',
            'metaActiveDimensions' => $drop_print_meta['dimensions'] ?? null,
            'metaActiveVariations' => $drop_print_meta['variations'] ?? array(),
            'metaPreviewId' => $meta_preview_id_val > 0 ? $meta_preview_id_val : null,
            'metaPreviewImageUrl' => $meta_preview_id_val > 0 ? wp_get_attachment_url($meta_preview_id_val) : null,
            'metaFileName' => $drop_print_meta['file'] ?? null,
            'checkDimensionsAction' => 'drop_print_check_dimensions',
            'apiBaseUrl' => defined('DROP_PRINT_API_URI') ? DROP_PRINT_API_URI : null,
            'apiAuthUserB64' => $user_settings['auth_username_b64'] ?? null,
            'apiAuthPassB64' => $user_settings['auth_password_b64'] ?? null,
            'clientUserConnectionId' => $user_settings['client_user_connection_id'] ?? null,
            'costCurrency' => $cost_currency_from_settings,
            'costCurrencySymbol' => get_woocommerce_currency_symbol($cost_currency_from_settings),
            'metaVariationsCurrency' => $drop_print_meta['variations_currency'] ?? null,
            'availableMedia' => $available_media,
            'defaultMediaId' => $default_media_id_to_use,
            'defaultPricelist' => $default_pricelist_data,
            'getPricelistAction' => 'drop_print_get_cached_pricelist',
            'default_image_resize' => $user_settings['default_image_resize'] ?? $default_user_settings['default_image_resize'],
            'maxUploadFileSizeMB' => $max_upload_size_mb,
        ];
        wp_localize_script('drop_print_core', 'dropPrintData', $localized_data);
        $base_deps = array('jquery','drop_print_core','wp-util','lodash');
        $scripts_to_enqueue = [
            'drop_print_overlay_feedback' => ['deps' => $base_deps],
            'drop_print_image_processing' => ['deps' => $base_deps],
            'drop_print_get_dimensions' => ['deps' => array_merge($base_deps, ['drop_print_overlay_feedback'])],
            'drop_print_products_from_json' => ['deps' => array_merge($base_deps, ['drop_print_overlay_feedback'])],
            'drop_print_dropzone' => ['deps' => array_merge($base_deps, ['dropzone-js','drop_print_overlay_feedback','drop_print_image_processing','drop_print_get_dimensions'])],
            'drop_print_core_ui' => ['deps' => array_merge($base_deps, ['drop_print_overlay_feedback','drop_print_products_from_json','drop_print_dropzone','drop_print_image_processing'])],
            'drop_print_product_matching' => ['deps' => array_merge($base_deps, ['drop_print_products_from_json','drop_print_overlay_feedback','drop_print_get_dimensions'])],
            'drop_print_product_selection' => ['deps' => array_merge($base_deps, ['drop_print_product_matching','drop_print_overlay_feedback'])],
            'drop_print_product_variation' => ['deps' => array_merge($base_deps, ['drop_print_product_selection','drop_print_overlay_feedback'])],
        ];
        foreach($scripts_to_enqueue as $handle => $config){
            $js_file_name = str_replace('_', '-', $handle).'.js';
            $path = DROP_PRINT_PLUGIN_PATH.'assets/js/'.$js_file_name;
            if(file_exists($path)){
                wp_enqueue_script($handle, DROP_PRINT_PLUGIN_URL.'assets/js/'.$js_file_name, $config['deps'], filemtime($path), true);
            }
        }
    }
    $order_list_screen_ids = array('edit-shop_order','woocommerce_page_wc-orders','shop_order');
    $is_order_page = in_array($screen->id, $order_list_screen_ids, true);
    $current_page_param = isset($_GET['page']) ? sanitize_key($_GET['page']) : '';
    $current_post_type_param = isset($_GET['post_type']) ? sanitize_key($_GET['post_type']) : '';
    if(!$is_order_page && $current_page_param === 'wc-orders' && $screen->base === 'woocommerce'){
        $is_order_page = true;
    }
    if(!$is_order_page && $hook_suffix === 'edit.php' && $current_post_type_param === 'shop_order'){
        $is_order_page = true;
    }
    if($is_order_page && $current_user_id > 0 && $is_connected_to_dp){
        wp_enqueue_style('dashicons');
        $modal_core_script_handle='drop-print-modal-core';
        $modal_core_script_relative_path='assets/js/production/drop-print-quote-and-pay-core.js';
        $modal_core_script_url=DROP_PRINT_PLUGIN_URL.$modal_core_script_relative_path;
        $modal_core_script_physical_path=DROP_PRINT_PLUGIN_PATH.$modal_core_script_relative_path;
        $modal_ui_script_handle='drop-print-modal-ui';
        $modal_ui_script_relative_path='assets/js/production/drop-print-quote-and-pay-ui.js';
        $modal_ui_script_url=DROP_PRINT_PLUGIN_URL.$modal_ui_script_relative_path;
        $modal_ui_script_physical_path=DROP_PRINT_PLUGIN_PATH.$modal_ui_script_relative_path;
        if(file_exists($modal_ui_script_physical_path) && file_exists($modal_core_script_physical_path)){
            wp_enqueue_style('drop-print-pre-production-styles',DROP_PRINT_PLUGIN_URL.'assets/css/production.css',array(),$plugin_version);
            wp_enqueue_script('stripe-v3','https://js.stripe.com/v3/',array(),'3.0',true);
            wp_enqueue_script($modal_ui_script_handle,$modal_ui_script_url,array('jquery','wp-i18n','wp-api'),$plugin_version,true);
            wp_enqueue_script($modal_core_script_handle,$modal_core_script_url,array('jquery',$modal_ui_script_handle),$plugin_version,true);
            if(function_exists('wp_set_script_translations')){
                wp_set_script_translations($modal_ui_script_handle,'drop-print',DROP_PRINT_PLUGIN_PATH.'languages');
            }
            $user_settings_for_js = drop_print_get_user_settings($current_user_id);
            $default_user_settings_for_js = drop_print_get_default_user_settings();
            $settings_for_js = wp_parse_args($user_settings_for_js, $default_user_settings_for_js);
            $api_uri_from_settings=$settings_for_js['api_uri_user_specific']??'';
            $server_api_url_for_js=!empty($api_uri_from_settings)?$api_uri_from_settings:(defined('DROP_PRINT_API_URI')?DROP_PRINT_API_URI:'');
            $server_origin_url='';
            if(!empty($server_api_url_for_js)){
                $parsed_url_origin=wp_parse_url($server_api_url_for_js);
                if(isset($parsed_url_origin['scheme'],$parsed_url_origin['host'])){
                    $server_origin_url=$parsed_url_origin['scheme'].'://'.$parsed_url_origin['host'];
                    if(isset($parsed_url_origin['port'])) $server_origin_url.=':'.$parsed_url_origin['port'];
                }
            }
            $localized_vars = array(
                'ajax_url'=>admin_url('admin-ajax.php'),
                'quote_initiate_nonce'=>wp_create_nonce('drop_print_initiate_quote_session_action'),
                'calculate_total_nonce'=>wp_create_nonce('drop_print_calculate_client_total_action'),
                'create_payment_intent_nonce'=>wp_create_nonce('drop_print_create_client_payment_intent_action'),
                'update_order_post_payment_nonce'=>wp_create_nonce('drop_print_update_client_order_post_payment_action'),
                'text_error_prefix'=>__('Error:','drop-print'),
                'text_generic_error'=>__('An unknown error occurred.','drop-print'),
                'text_quote_pay'=>__('Drop Print','drop-print'),
                'text_close_modal'=>__('Close','drop-print'),
                'text_initiating_quote_session'=>__('Initiating quote session...','drop-print'),
                'text_requesting_quote'=>__('Requesting Quote...','drop-print'),
                'text_updating_quote'=>__('Updating quote...','drop-print'),
                'text_payment_for_order'=>__('Payment for Order #%1$s','drop-print'),
                'text_shipping_method_label'=>__('Shipping Method:','drop-print'),
                'text_selected_country'=>__('the selected country','drop-print'),
                'text_shipping_unavailable_default_msg_sprintf'=>__('Shipping method "%1$s" is not available for %2$s.','drop-print'),
                'text_shipping_unavailable_pro_prompt'=>__('Please try selecting an alternative shipping method from the dropdown above.','drop-print'),
                'text_contact_support_shipping_unavailable'=>__('As this shipping method is unavailable, please contact support to proceed with this order.','drop-print'),
                'text_production_quote_title'=>__('Production Quote:','drop-print'),
                'text_printed_in'=>__('Printed in ','drop-print'),
                'text_ships_from'=>__('Ships from:','drop-print'),
                'text_print_services_total'=>__('Print Services Total','drop-print'),
                'text_delivery'=>__('Delivery','drop-print'),
                'text_default_shipping_unavailable_contact_support'=>__('The default shipping method is not available. Please contact support.','drop-print'),
                'text_total_due'=>__('Total Due','drop-print'),
                'text_shipping_notice_pro'=>__('Note: Total due is for items only. Shipping cost will be finalized once a valid method is selected.','drop-print'),
                'text_pro_pricing_applied'=>__('Pro discount applied.','drop-print'),
                'text_pro_shipping_upsell'=>__('Pro users can select from Budget to Overnight shipping.','drop-print'),
                'text_pay_now'=>__('Pay Now','drop-print'),
                'text_pay_with_saved_card_sprintf'=>__('Pay with %brand% •••• %last4%','drop-print'),
                'text_manage_payment_methods_link'=>__('Manage payment methods on Drop Print','drop-print'),
                'text_use_different_card_link'=>__('Use a different card?','drop-print'),
                'text_card_details_label'=>__('Card Details','drop-print'),
                'text_add_card_for_future_sprintf_v2'=>__('You can <a href="%add_card_url%" target="_blank" rel="noopener" class="dp-add-card-link-close-modal">add this card to your account</a> for faster checkout next time (modal will close).','drop-print'),
                'text_pro_upsell_headline_v3' => __('%savings_percentage%% OFF TODAY','drop-print'),
                'text_pro_upsell_body_v3' => __('Save %savings_amount% on this order by upgrading to Pro now! Enjoy order discounts, select from numerous delivery methods and use a saved payment card <a href="%manage_cards_url%" target="_blank" rel="noopener" title="Manage payment methods (opens new tab)"><span class="dashicons dashicons-external"></span></a> to automate your workflow to send orders directly to print. Learn more at: <a href="%pro_url%" target="_blank" rel="noopener" title="Learn about Pro (opens new tab)">drop-print.com/pro <span class="dashicons dashicons-external"></span></a>.','drop-print'),
                'text_pro_add_card_for_auto_prod_off_v2' => __('Pro Feature: Auto-Production is OFF. <a href="%manage_cards_url%" target="_blank" rel="noopener">Add a payment method</a> to enable Auto-Production later.','drop-print'),
                'text_pro_add_card_for_auto_prod_on_v2' => __('Warning: Auto-Production is ON, but orders will not proceed as no payment card is on file. <a href="%manage_cards_url%" target="_blank" rel="noopener">Please add one</a>. Alternatively, enter your card details above to pay for this order now.','drop-print'),
                'text_stripe_init_fail'=>__('Payment gateway failed to initialize. Please close and try again.','drop-print'),
                'text_stripe_not_loaded_card_unavailable'=>__('Payment gateway not configured or failed to load. Card form unavailable.','drop-print'),
                'text_stripe_form_init_fail'=>__('Failed to initialize payment form.','drop-print'),
                'text_payment_session_init_fail'=>__('Failed to initialize payment session.','drop-print'),
                'text_stripe_not_ready_for_confirm'=>__('Payment gateway not ready or session invalid.','drop-print'),
                'text_card_details_not_ready_for_confirm'=>__('Card details are not ready.','drop-print'),
                'text_saved_card_failed_loading_new'=>__('Saved card failed. Loading new card form...','drop-print'),
                'text_payment_status_label'=>__('Payment status:','drop-print'),
                'text_payment_confirm_failed_unknown'=>__('Payment confirmation failed. Please try again.','drop-print'),
                'text_unexpected_error_payment_confirm_sprintf'=>__('An unexpected error occurred: %1$s','drop-print'),
                'text_payment_successful_title'=>__('Payment Successful!','drop-print'),
                'text_awaiting_production_confirmation'=>__('Awaiting production confirmation from the server.','drop-print'),
                'text_order_queued_status_update_soon'=>__('Order is being queued. You will see a status update shortly.','drop-print'),
                'text_processing_payment'=>__('Processing Payment...','drop-print'),
                'text_status_awaiting_webhook'=>__('Awaiting Payment Confirmation','drop-print'),
                'text_status_paid_in_queue'=>__('Paid, In Queue','drop-print'),
                'text_view_stripe_receipt_title'=>__('View Stripe Receipt','drop-print'),
                'text_payment_processed_no_receipt_title'=>__('Payment processed, receipt link not available.','drop-print'),
                'text_status_processing'=>__('Processing','drop-print'),
                'text_status_in_print_queue'=>__('In Print Queue','drop-print'),
                'text_status_printing'=>__('Printing','drop-print'),
                'text_status_shipped'=>__('Shipped','drop-print'),
                'text_status_file_issue'=>__('File Issue Detected','drop-print'),
                'text_status_unknown'=>__('Unknown','drop-print'),
                'text_status_not_applicable'=>__('-','drop-print'),
                'text_pro_select_valid_shipping_to_pay'=>__('Please select a valid shipping method to enable payment.','drop-print'),
                'text_default_shipping_unavailable_no_pay'=>__('The default shipping is unavailable. Payment cannot be processed. Please contact support.','drop-print'),
                'server_origin'=>$server_origin_url,
                'stripe_publishable_key'=>$settings_for_js['stripe_publishable_key']??'',
                'manage_cards_url'=>($server_origin_url?trailingslashit($server_origin_url):'https://drop-print.com/').'my-account/payment-methods/',
                'add_payment_method_url'=>($server_origin_url?trailingslashit($server_origin_url):'https://drop-print.com/').'my-account/add-payment-method/',
                'pro_signup_url'=>($server_origin_url?trailingslashit($server_origin_url):'https://drop-print.com/').'pro/',
                'is_pro_user'=>(bool)($settings_for_js['pro_status']??false),
                'client_auto_production_setting' => $settings_for_js['auto_production'] ?? 'off',
                'default_shipping_method'=>$settings_for_js['default_shipping_method']??'standard',
                'available_shipping_methods'=>array(
                    'standard'=>__('Standard','drop-print'),
                    'budget'=>__('Budget','drop-print'),
                    'express'=>__('Express','drop-print'),
                    'overnight'=>__('Overnight','drop-print')
                )
            );
            wp_localize_script($modal_ui_script_handle,'drop_print_vars', $localized_vars);
        }
    }
}
add_action('admin_enqueue_scripts', 'drop_print_enqueue_admin_scripts');