<?php
/**
 * Drop Print WooCommerce Product Tab & Meta Box Functionality (v1.1).
 * This file is responsible for adding the "Drop Print" tab to the WooCommerce
 * product data section and rendering its main user interface panel.
 * This panel includes the Dropzone for file uploads, a preview area for images, a list for
 * displaying selectable print products fetched from pricelists, and various
 * controls. It also defines a meta box for displaying a preview of the Drop
 * Print image on the product edit screen.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
function drop_print_add_product_type_option( $product_type_options ) {
	$product_type_options['drop_print'] = array(
		'id'            => '_drop_print_enable',
		'wrapper_class' => 'show_if_simple show_if_variable drop-print-enable-option',
		'label'         => __( 'Drop Print', 'drop-print' ),
		'description'   => __( 'Enable Drop Print fulfillment for this product.', 'drop-print' ),
		'default'       => 'no',
	);
	return $product_type_options;
}
add_filter( 'product_type_options', 'drop_print_add_product_type_option' );
function drop_print_add_product_data_tab( $tabs ) {
	$tabs['drop_print'] = array(
		'label'    => __( 'Drop Print', 'drop-print' ),
		'target'   => 'drop-print-product-data-panel',
		'class'    => array( 'drop-print-tab', 'hide_if_external', 'hide_if_grouped' ),
		'priority' => 25,
	);
	return $tabs;
}
add_filter( 'woocommerce_product_data_tabs', 'drop_print_add_product_data_tab' );
function drop_print_render_product_data_panel() {
	global $post;
	$product = ( $post && $post->ID ) ? wc_get_product( $post->ID ) : null;
	$overlay_style = 'display: none;'; $overlay_class = 'drop-print-overlay'; $overlay_icon_class = ''; $overlay_title = '';
	$overlay_message = ''; $show_initial_actions = false; $is_blocked = false;
	if ( ! $product || 'auto-draft' === $post->post_status ) {
		$is_blocked = true;
		$overlay_style = 'display: flex;'; $overlay_class .= ' is-blocked is-visible'; $overlay_icon_class = 'dashicons dashicons-warning';
		$overlay_title = __( 'Save Product First', 'drop-print' ); $overlay_message = __( 'Drop Print requires this product to be saved (even as a draft) before you can use this panel.', 'drop-print' );
		$show_initial_actions = true;
	} elseif ( $product && ! $product->is_type( 'variable' ) ) {
		$is_blocked = true;
		$overlay_style = 'display: flex;';
		$overlay_class .= ' is-blocked is-visible'; $overlay_icon_class = 'dashicons dashicons-info-outline';
		$overlay_title = __( 'Variable Product Required', 'drop-print' );
		$overlay_message = __( 'Drop Print works best with the \'Variable product\' type. If needed, this will be set automatically when Drop Print is enabled and the product is saved.', 'drop-print' );
	}
	$docs_url = 'https://drop-print.com/docs';
	?>
	<div id="drop-print-product-data-panel" class="panel woocommerce_options_panel">
		<div class="options_group <?php echo $is_blocked ? 'drop-print-content-blocked' : ''; ?>">
			<div id="drop-print-dropzone-wrapper">
				<div id="drop-print-dropzone" class="drop-print-dropzone">
					<div class="dropzone-inner">
						<div id="drop-print-prompt" class="drop-print-prompt">
							<span class="dashicons dashicons-cloud-upload drop-print-prompt-icon"></span>
							<h3><?php esc_html_e( 'Drop Zone', 'drop-print' ); ?></h3>
							<p><?php esc_html_e( 'Select or drag-n-drop a file to begin.', 'drop-print' ); ?><br><small><?php esc_html_e( 'Max image (JPEG, PNG, TIFF) file size 256MB', 'drop-print' ); ?></small></p>
						</div>
					</div>
				</div>
			</div>
			<div id="drop-print-step-1" class="drop-print-step">
				<div class="drop-print-columns">
					<div class="drop-print-preview-col" id="drop-print-preview-col">
						<div id="drop-print-image-wrapper" class="drop-print-image-wrapper" style="display:none;">
							<div id="drop-print-dimension-height" class="drop-print-dimension-overlay"><div id="drop-print-preview-dimensions-height" class="drop-print-dimension-label"></div></div>
							<img id="drop-print-image-preview" class="drop-print-preview" style="display:none;" alt="<?php esc_attr_e( 'Image Preview', 'drop-print' ); ?>">
							<div id="drop-print-dimension-width" class="drop-print-dimension-overlay"><div id="drop-print-preview-dimensions-width" class="drop-print-dimension-label"></div></div>
						</div>
					</div>
					<div class="drop-print-products-col" id="drop-print-products-col">
						<div class="drop-print-controls-header" id="drop-print-media-select-container">
							<div class="drop-print-media-select-wrapper">
								<label for="drop-print-media-select" class="screen-reader-text"><?php esc_html_e( 'Select Media Type', 'drop-print' ); ?></label>
								<select id="drop-print-media-select" name="drop_print_media_select">
									<option value=""><?php esc_html_e( 'Loading media types...', 'drop-print' ); ?></option>
								</select>
							</div>
							<div class="drop-print-product-search-wrapper">
								<label for="drop-print-product-search" class="screen-reader-text"><?php esc_html_e( 'Search Products', 'drop-print' ); ?></label>
								<input type="search" id="drop-print-product-search" name="drop_print_product_search" placeholder="<?php esc_attr_e( 'Search...', 'drop-print' ); ?>" />
							</div>
						</div>
						<div id="drop-print-product-list-container">
							<p class="drop-print-product-list-loading"><?php esc_html_e( 'Loading print products...', 'drop-print' ); ?></p>
						</div>
						<div class="drop-print-product-list-footer">
                            <div id="drop-print-show-all-trigger" class="drop-print-show-all-trigger" role="button" tabindex="0" aria-disabled="true">
                                <span class="drop-print-show-all-text"><?php esc_html_e( 'Show All Paper Sizes', 'drop-print' ); ?></span>
                                <span class="drop-print-show-all-indicator dashicons dashicons-arrow-down-alt2"></span>
                            </div>
						</div>
					</div>
				</div>
				<div class="drop-print-actions">
					<button type="button" id="drop-print-reset-button" class="button" disabled><?php esc_html_e( 'Reset', 'drop-print' ); ?></button>
					<div id="drop-print-file-info-wrapper" class="drop-print-field drop-print-file-info-wrapper" style="display: none;">
						<div id="drop-print-file-info-container" class="drop-print-file-info-container">
							<div id="drop-print-file-info" class="drop-print-file-info">
								<span id="drop-print-file-name"></span>
							</div>
						</div>
					</div>
					<button type="button" id="drop-print-add-variations-button" class="button button-primary" disabled><?php esc_html_e( 'Create Variations', 'drop-print' ); ?></button>
				</div>
			</div>
			<div id="drop-print-panel-overlay" class="<?php echo esc_attr( $overlay_class ); ?>" style="<?php echo esc_attr( $overlay_style ); ?>">
				<div class="drop-print-overlay-content">
					<div class="drop-print-overlay-icon">
						<span class="spinner"></span>
						<span class="<?php echo esc_attr( $overlay_icon_class ); ?>"></span>
					</div>
					<h3 class="drop-print-overlay-title"><?php echo esc_html( $overlay_title ); ?></h3>
					<div class="drop-print-overlay-message">
						<?php echo wp_kses_post( $overlay_message ); ?>
					</div>
					<div id="dp-upload-progress-container" style="display: none; width: 80%; margin: 20px auto;">
						<div id="dp-upload-progress-text" style="text-align: center; margin-bottom: 5px;"></div>
						<div id="dp-upload-progress-bar-outer" style="background-color: #e0e0e0; border-radius: 4px; padding: 2px;">
							<div id="dp-upload-progress-bar-inner" style="width: 0%; height: 10px; background-color: #007cba; border-radius: 2px; transition: width 0.2s ease-out;"></div>
						</div>
					</div>
					<div class="drop-print-overlay-actions" style="<?php echo $show_initial_actions ? '' : 'display: none;'; ?>">
						<button type="button" id="drop-print-overlay-confirm-reset-btn" class="button button-primary delete-button drop-print-overlay-button-confirm-reset" style="display: none;"><?php esc_html_e( 'Confirm Reset', 'drop-print' ); ?></button>
						<button type="button" id="drop-print-overlay-reset-btn" class="button button-secondary drop-print-overlay-button-reset"><?php esc_html_e( 'Cancel', 'drop-print' ); ?></button>
						<button type="button" id="drop-print-overlay-download-btn" class="button drop-print-overlay-button-download" style="display: none;"><?php esc_html_e( 'Download Template', 'drop-print' ); ?></button>
						<a href="<?php echo esc_url( $docs_url ); ?>" target="_blank" rel="noopener noreferrer" id="drop-print-overlay-docs-btn" class="button drop-print-overlay-button-docs" style="display: none;"><?php esc_html_e( 'Plugin Docs', 'drop-print' ); ?></a>
						<button type="button" id="drop-print-overlay-save-btn" class="button button-primary drop-print-overlay-button-save" style="display: none;"><?php esc_html_e( 'Save Changes', 'drop-print' ); ?></button>
						<button type="button" id="drop-print-overlay-refresh-btn" class="button drop-print-overlay-button-refresh" style="display: none;"><?php esc_html_e( 'Refresh Pricelist', 'drop-print' ); ?></button>
						<button type="button" id="drop-print-overlay-save-now-btn" class="button button-primary drop-print-overlay-button-save-now" style="display: none;"><?php esc_html_e( 'Save Now', 'drop-print' ); ?></button>
						<button type="button" id="drop-print-overlay-ok-btn" class="button button-secondary drop-print-overlay-button-ok" style="display: none;"><?php esc_html_e( 'OK', 'drop-print' ); ?></button>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
add_action( 'woocommerce_product_data_panels', 'drop_print_render_product_data_panel' );