<?php
/**
 * Plugin Name: Drop Print
 * Plugin URI: https://drop-print.com
 * Description: Sell giclee prints with WooCommerce with Drop Print's specialised fine art print-on-demand fulfillment service, built specifically for artists and galleries.
 * Version: 1.1.2
 * Author: Drop Print
 * Author URI: https://drop-print.com
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: drop-print
 * Domain Path: /languages
 * Requires at least: 6.0
 * Tested up to: 6.8.2
 * Requires PHP: 7.4
 * WC requires at least: 8.6
 * WC tested up to: 9.9.3
 * Requires Plugins: woocommerce
 */
if(!defined('WPINC')){die;}
define('DROP_PRINT_VERSION','1.1.2');
define('DROP_PRINT_API_URI','https://api.drop-print.com/wp-json/print-server/v1');
define('DROP_PRINT_PLUGIN_URL',plugin_dir_url(__FILE__));
define('DROP_PRINT_PLUGIN_PATH',plugin_dir_path(__FILE__));
define('DROP_PRINT_PLUGIN_FILE',__FILE__);
define('DROP_PRINT_UPLOAD_BASE_DIR',trailingslashit(wp_upload_dir()['basedir']).'drop-print');
define('DROP_PRINT_CACHE_DIR',trailingslashit(DROP_PRINT_UPLOAD_BASE_DIR).'pricelists');
add_action('before_woocommerce_init', function(){
    if(class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)){
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});
require_once DROP_PRINT_PLUGIN_PATH.'includes/utils.php';
require_once DROP_PRINT_PLUGIN_PATH.'includes/callbacks.php';
require_once DROP_PRINT_PLUGIN_PATH.'includes/plugin-activation.php';
require_once DROP_PRINT_PLUGIN_PATH.'includes/admin/admin-update-pricelists.php';
require_once DROP_PRINT_PLUGIN_PATH.'includes/admin/admin-settings-page.php';
require_once DROP_PRINT_PLUGIN_PATH.'includes/admin/admin-get-client-id.php';
require_once DROP_PRINT_PLUGIN_PATH.'includes/admin/production/json-payload-builder.php';
require_once DROP_PRINT_PLUGIN_PATH.'includes/admin/production/auto-production.php';
require_once DROP_PRINT_PLUGIN_PATH.'includes/admin/production/production-handlers.php';
require_once DROP_PRINT_PLUGIN_PATH.'includes/admin/production/production-column.php';
register_activation_hook(DROP_PRINT_PLUGIN_FILE,'drop_print_plugin_activation');
register_deactivation_hook(DROP_PRINT_PLUGIN_FILE,'drop_print_plugin_deactivate');
function drop_print_init(){
    require_once DROP_PRINT_PLUGIN_PATH.'includes/enqueues.php';
    if(is_admin()){
        $current_user_id = get_current_user_id();
        if($current_user_id > 0){
            $user_settings = drop_print_get_user_settings($current_user_id);
            if(!empty($user_settings['client_user_connection_id'])){
                require_once DROP_PRINT_PLUGIN_PATH.'includes/admin/product-edit-panel.php';
                require_once DROP_PRINT_PLUGIN_PATH.'includes/admin/dimension-check-handler.php';
                require_once DROP_PRINT_PLUGIN_PATH.'includes/admin/file-upload-handler.php';
                require_once DROP_PRINT_PLUGIN_PATH.'includes/admin/file-delete-handler.php';
                require_once DROP_PRINT_PLUGIN_PATH.'includes/admin/product-variation-handler.php';
            }
        }
    }
}
add_action('plugins_loaded','drop_print_init');