/**
 * DropPrint Core Namespace, Configuration, State, and Initial File Handling Logic.
 * Version 1.1.2
 */
if ( typeof Dropzone !== 'undefined' ) {
 Dropzone.autoDiscover = false;
}
( function( $ ) {
 'use strict';
    window.dropPrint = {
  ...( window.dropPrint || {} ),
  state: {
   currentFile: null,
   dropzoneInstance: null,
   currentBestMatch: null,
   dimensionsKnown: false,
   uploadCompleteForDimensions: false,
   variationsStagedNotSaved: false,
   prospectiveVariations: null,
   fileDimensions: null,
   attachmentUrl: null,
   jsonLoadingPromise: null,
   dropPrintRequiresSave: false,
   metaFileName: window.dropPrintData?.metaFileName || null,
   metaPreviewId: window.dropPrintData?.metaPreviewId || null,
   metaActiveDimensions: window.dropPrintData?.metaActiveDimensions || null,
   metaActiveVariations: window.dropPrintData?.metaActiveVariations || [],
   currentMediaId: window.dropPrintData?.defaultMediaId || null,
   showingAllProducts: false,
   ...( window.dropPrint?.state || {} ),
  },
  config: {
   ajaxUrl: window.dropPrintData?.ajaxUrl,
   nonce: window.dropPrintData?.nonce,
   productId: window.dropPrintData?.productId,
   apiBaseUrl: window.dropPrintData?.apiBaseUrl,
   apiAuthUserB64: window.dropPrintData?.apiAuthUserB64,
   apiAuthPassB64: window.dropPrintData?.apiAuthPassB64,
   costCurrency: window.dropPrintData?.costCurrency,
   costCurrencySymbol: window.dropPrintData?.costCurrencySymbol,
   priceMargin: window.dropPrintData?.priceMargin,
   wcCurrency: window.dropPrintData?.wcCurrency,
   wcCurrencySymbol: window.dropPrintData?.wcCurrencySymbol,
   wcMeasurementUnit: window.dropPrintData?.wcMeasurementUnit,
   metaIsActive: window.dropPrintData?.metaIsActive,
   checkDimensionsAction: window.dropPrintData?.checkDimensionsAction,
   metaVariationsCurrency: window.dropPrintData?.metaVariationsCurrency,
   availableMedia: window.dropPrintData?.availableMedia || [],
   defaultMediaId: window.dropPrintData?.defaultMediaId || null,
   defaultPricelist: window.dropPrintData?.defaultPricelist || null,
   getPricelistAction: window.dropPrintData?.getPricelistAction,
   metaPreviewImageUrl: window.dropPrintData?.metaPreviewImageUrl || null,
settingsPageUrl: window.dropPrintData?.settingsPageUrl,
   MAX_FILE_SIZE_MB: 256,
   MAX_PREVIEW_DIMENSION: 800,
   QUICK_DIM_CHUNK_SIZE: 1024 * 128,
   maxUploadFileSizeMB: window.dropPrintData?.maxUploadFileSizeMB || 256,
   ...( window.dropPrint?.config || {} ),
  },
  elements: {},
 };
 function dropPrintGetImageDimensions( file ) {
  return new Promise( ( resolve, reject ) => {
   if ( ! window.FileReader ) { return reject( new Error( 'FileReader API not supported.' ) ); }
   const reader = new FileReader();
   reader.onload = function( e ) {
    const img = new Image();
    img.onload = function() {
     const width = img.naturalWidth || img.width; const height = img.naturalHeight || img.height;
     if ( width > 0 && height > 0 ) { resolve( { width, height } ); } else { reject( new Error( 'Image dimensions read as zero.' ) ); }
    };
    img.onerror = function() { reject( new Error( 'Image object could not load data URL.' ) ); };
    img.src = e.target.result;
   };
   reader.onerror = function() { reject( new Error( 'FileReader failed to read file.' ) ); };
   reader.readAsDataURL( file );
  } );
 }
 function dropPrintPerformQuickCheck( file ) {
  const { config, dropPrintUpdateOverlay } = window.dropPrint || {};
  return new Promise( ( resolve, reject ) => {
   if ( !config || !config.ajaxUrl || !config.nonce || !config.productId || !config.checkDimensionsAction ) { return reject( new Error('Missing configuration for quick dimension check.') ); }
   if ( !file || typeof file.slice !== 'function' || file.size < 1) { return reject( new Error('Invalid file object for quick dimension check.') ); }
   if ( typeof dropPrintUpdateOverlay === 'function' ) { dropPrintUpdateOverlay( 'is-loading', 'Checking Dimensions', 'Analyzing file header...' ); }
   const blob = file.slice( 0, config.QUICK_DIM_CHUNK_SIZE );
   const formData = new FormData();
   formData.append( 'action', config.checkDimensionsAction ); formData.append( 'nonce', config.nonce ); formData.append( 'product_id', config.productId ); formData.append( 'file_chunk', blob, file.name );
   $.ajax( { url: config.ajaxUrl, type: 'POST', data: formData, processData: false, contentType: false, dataType: 'json', } )
   .done( function( response ) {
    if ( response?.success && response?.data?.width > 0 && response?.data?.height > 0 ) { resolve( { width: response.data.width, height: response.data.height } );
    } else { reject( new Error( response?.data?.message || 'Dimensions not found in header.' ) ); }
   } ).fail( function( jqXHR, textStatus, errorThrown ) {
    let errorMsg = 'AJAX error during dimension check.';
    if ( jqXHR.responseJSON?.data?.message ) { errorMsg = jqXHR.responseJSON.data.message; }
    else if (typeof jqXHR.responseText === 'string' && jqXHR.responseText.length < 100) { errorMsg = jqXHR.responseText; }
    reject( new Error( errorMsg ) );
   } );
  } );
 }
 function dropPrintTriggerFullUpload() {
  const { state, dropPrintUpdateOverlay, dropPrintShowErrorOverlay } = window.dropPrint || {};
  const overlayMessage = '<p>Could not read dimensions quickly from the file header.</p><p>Performing full upload to determine dimensions on the server. This may take a moment...</p>';
  if ( typeof dropPrintUpdateOverlay !== 'function' || typeof dropPrintShowErrorOverlay !== 'function' || !state?.dropzoneInstance ) { console.error( 'DropPrint Error: Cannot trigger full upload - updateOverlay/showErrorOverlay or dropzoneInstance missing.' ); alert( 'DropPrint Critical Error: Cannot start file upload.' ); return; }
  dropPrintUpdateOverlay( 'is-loading', 'Checking Dimensions', overlayMessage, { showActions: false } );
  state.uploadCompleteForDimensions = true;
  setTimeout( () => {
   try {
    if ( ! state?.dropzoneInstance ) { console.error( 'DropPrint Error inside setTimeout: Dropzone instance lost.' ); dropPrintShowErrorOverlay( 'Upload Error', 'Upload component became unavailable.' ); return; }
    const qFiles = state.dropzoneInstance.getQueuedFiles();
    if ( qFiles.length === 0 ) { console.error( 'DropPrint Error: processQueue called but no files are queued (setTimeout). Current file object:', state.currentFile ); dropPrintShowErrorOverlay( 'Upload Error', 'Cannot start upload: No file found in queue after delay. Please reset.' ); return; }
    state.dropzoneInstance.processQueue();
   } catch ( dzError ) { console.error( 'DropPrint Error: Dropzone processQueue failed inside setTimeout:', dzError ); dropPrintShowErrorOverlay( 'Upload Error', 'Could not start the main file upload process. Please try resetting.' ); }
  }, 200 );
 }
 function dropPrintHandleFileAdded( file ) {
  const { state, elements, config, dropPrintUpdateOverlay, dropPrintShowErrorOverlay, dropPrintCreateOptimizedPreview, dropPrintCreateDimensionPlaceholder, dropPrintHandleFilePostDimensions } = window.dropPrint || {};
  if ( !state || !elements || !config || typeof dropPrintUpdateOverlay !== 'function' || typeof dropPrintShowErrorOverlay !== 'function' || typeof dropPrintCreateOptimizedPreview !== 'function' || typeof dropPrintCreateDimensionPlaceholder !== 'function' || typeof dropPrintHandleFilePostDimensions !== 'function' ) { console.error('DropPrint Error (HandleFileAdded): Missing core components.'); alert('DropPrint Critical Error: Core components failed. Please reload.'); return; }
  state.currentFile = file; state.currentBestMatch = null; state.dimensionsKnown = false;
  state.uploadCompleteForDimensions = false; state.prospectiveVariations = null; state.variationsStagedNotSaved = false; state.fileDimensions = null; state.dropPrintRequiresSave = false;
  if (typeof window.dropPrint.dropPrintUpdateFileInfo === 'function') { window.dropPrint.dropPrintUpdateFileInfo(null, null); }
  $( elements.dropzoneWrapper ).hide(); $( elements.dropPrintStep ).addClass( 'active' ); $( elements.previewColumn ).show();
  $( elements.productsColumn ).addClass( 'active' ); $( elements.dropPrintImageWrapper ).show();
  elements.dropPrintImagePreview.style.display = 'none'; elements.dropPrintImagePreview.classList.remove('visible');
  $( elements.dropPrintResetButton ).prop( 'disabled', false );
  $( elements.dropPrintAddVariationsButton ).prop( 'disabled', true ).removeClass('drop-print-pulse');
  dropPrintCreateOptimizedPreview( file, function( previewDataUrl ) {
   if ( previewDataUrl ) {
    elements.dropPrintImagePreview.src = previewDataUrl; elements.dropPrintImagePreview.style.display = 'block';
    elements.dropPrintImagePreview.onload = () => { elements.dropPrintImagePreview.classList.add( 'visible' ); };
    if (elements.dropPrintImagePreview.complete) { elements.dropPrintImagePreview.classList.add( 'visible' ); }
   } else { console.warn('DropPrint Preview: Failed to generate client-side preview.'); }
  } );
  dropPrintPerformQuickCheck( file ).then( ( dims ) => {
   state.fileDimensions = dims; state.dimensionsKnown = true;
   state.currentFile._cachedDimensions = { longestEdge: Math.max( dims.width, dims.height ), shortestEdge: Math.min( dims.width, dims.height ) };
   if (typeof window.dropPrint.dropPrintUpdateFileInfo === 'function') { window.dropPrint.dropPrintUpdateFileInfo(dims.width, dims.height); }
   if (!elements.dropPrintImagePreview.src) { dropPrintCreateDimensionPlaceholder(dims.width, dims.height); }
   dropPrintHandleFilePostDimensions( state.currentFile );
  } ).catch( ( error ) => {
   console.warn( 'DropPrint: Quick dimension check failed:', error.message, 'Attempting client-side full read...' );
   dropPrintUpdateOverlay( 'is-loading', 'Checking Dimensions', 'Trying client-side check...' );
   dropPrintGetImageDimensions( file ).then( ( dims ) => {
    state.fileDimensions = dims; state.dimensionsKnown = true;
    state.currentFile._cachedDimensions = { longestEdge: Math.max( dims.width, dims.height ), shortestEdge: Math.min( dims.width, dims.height ) };
    if (typeof window.dropPrint.dropPrintUpdateFileInfo === 'function') { window.dropPrint.dropPrintUpdateFileInfo(dims.width, dims.height); }
    if (!elements.dropPrintImagePreview.src) { dropPrintCreateDimensionPlaceholder(dims.width, dims.height); }
    dropPrintHandleFilePostDimensions( state.currentFile );
   }).catch( ( fullReadError ) => {
     console.warn( 'DropPrint: Client-side full read also failed:', fullReadError.message, 'Falling back to full server upload for dimensions.' );
     if (!elements.dropPrintImagePreview.src) { dropPrintCreateDimensionPlaceholder(0, 0); }
     dropPrintTriggerFullUpload();
   });
  } );
 }
 window.dropPrint.dropPrintHandleFileAdded = dropPrintHandleFileAdded;
}( jQuery ) );