<?php
if (!defined('ABSPATH')) exit;

/**
 * Render Countdown Timer
 */
function wpdcsm_render_countdown($data) {
    if (!$data['countdown_enabled']) {
        return '';
    }
    
    $target_date = strtotime($data['countdown_date']);
    $now = current_time('timestamp');
    
    if ($target_date <= $now) {
        return '<div class="wpdcsm-countdown-expired">' . esc_html__('We\'re Live!', 'dream-coming-soon') . '</div>';
    }
    
    // Convert to milliseconds for JavaScript
    $target_milliseconds = $target_date * 1000;
    
    ob_start();
    ?>
    <div class="wpdcsm-countdown-wrapper">
        <?php if (!empty($data['countdown_label'])): ?>
            <div class="wpdcsm-countdown-label"><?php echo esc_html($data['countdown_label']); ?></div>
        <?php endif; ?>
        <div class="wpdcsm-countdown" data-target="<?php echo esc_attr($target_milliseconds); ?>">
            <div class="wpdcsm-countdown-item">
                <span class="wpdcsm-countdown-number wpdcsm-days">0</span>
                <span class="wpdcsm-countdown-label"><?php echo esc_html__('Days', 'dream-coming-soon'); ?></span>
            </div>
            <div class="wpdcsm-countdown-item">
                <span class="wpdcsm-countdown-number wpdcsm-hours">0</span>
                <span class="wpdcsm-countdown-label"><?php echo esc_html__('Hours', 'dream-coming-soon'); ?></span>
            </div>
            <div class="wpdcsm-countdown-item">
                <span class="wpdcsm-countdown-number wpdcsm-minutes">0</span>
                <span class="wpdcsm-countdown-label"><?php echo esc_html__('Minutes', 'dream-coming-soon'); ?></span>
            </div>
            <div class="wpdcsm-countdown-item">
                <span class="wpdcsm-countdown-number wpdcsm-seconds">0</span>
                <span class="wpdcsm-countdown-label"><?php echo esc_html__('Seconds', 'dream-coming-soon'); ?></span>
            </div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

/**
 * Render Newsletter Form
 */
function wpdcsm_render_newsletter($data) {
    if (!$data['newsletter_enabled']) {
        return '';
    }
    
    ob_start();
    ?>
    <div class="wpdcsm-newsletter-wrapper">
        <?php if (!empty($data['newsletter_title'])): ?>
            <h3 class="wpdcsm-newsletter-title"><?php echo esc_html($data['newsletter_title']); ?></h3>
        <?php endif; ?>
        <?php if (!empty($data['newsletter_description'])): ?>
            <p class="wpdcsm-newsletter-description"><?php echo esc_html($data['newsletter_description']); ?></p>
        <?php endif; ?>
        <form class="wpdcsm-newsletter-form" id="wpdcsm-newsletter-form">
            <?php if ($data['newsletter_show_name']): ?>
                <input type="text" name="name" class="wpdcsm-newsletter-name" placeholder="<?php echo esc_attr__('Your Name', 'dream-coming-soon'); ?>">
            <?php endif; ?>
            <input type="email" name="email" class="wpdcsm-newsletter-email" placeholder="<?php echo esc_attr__('Your Email', 'dream-coming-soon'); ?>" required>
            <button type="submit" class="wpdcsm-newsletter-button"><?php echo esc_html($data['newsletter_button_text']); ?></button>
            <div class="wpdcsm-newsletter-message"></div>
        </form>
    </div>
    <?php
    return ob_get_clean();
}

/**
 * Render Social Media Icons
 */
function wpdcsm_render_social($data) {
    if (!$data['social_enabled']) {
        return '';
    }
    
    $social_links = array();
    if (!empty($data['social_facebook'])) $social_links['facebook'] = $data['social_facebook'];
    if (!empty($data['social_twitter'])) $social_links['twitter'] = $data['social_twitter'];
    if (!empty($data['social_instagram'])) $social_links['instagram'] = $data['social_instagram'];
    if (!empty($data['social_linkedin'])) $social_links['linkedin'] = $data['social_linkedin'];
    if (!empty($data['social_youtube'])) $social_links['youtube'] = $data['social_youtube'];
    if (!empty($data['social_pinterest'])) $social_links['pinterest'] = $data['social_pinterest'];
    if (!empty($data['social_tiktok'])) $social_links['tiktok'] = $data['social_tiktok'];
    if (!empty($data['social_github'])) $social_links['github'] = $data['social_github'];
    
    if (empty($social_links)) {
        return '';
    }
    
    ob_start();
    ?>
    <div class="wpdcsm-social-wrapper">
        <?php if (!empty($data['social_title'])): ?>
            <h4 class="wpdcsm-social-title"><?php echo esc_html($data['social_title']); ?></h4>
        <?php endif; ?>
        <div class="wpdcsm-social-icons">
            <?php foreach ($social_links as $platform => $url): ?>
                <a href="<?php echo esc_url($url); ?>" target="_blank" rel="noopener noreferrer" class="wpdcsm-social-icon wpdcsm-social-<?php echo esc_attr($platform); ?>" aria-label="<?php echo esc_attr(ucfirst($platform)); ?>">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                        <?php if ($platform === 'facebook'): ?>
                            <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                        <?php elseif ($platform === 'twitter'): ?>
                            <path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/>
                        <?php elseif ($platform === 'instagram'): ?>
                            <path d="M12 0C8.74 0 8.333.015 7.053.072 5.775.132 4.905.333 4.14.63c-.789.306-1.459.717-2.126 1.384S.935 3.35.63 4.14C.333 4.905.131 5.775.072 7.053.012 8.333 0 8.74 0 12s.015 3.667.072 4.947c.06 1.277.261 2.148.558 2.913.306.788.717 1.459 1.384 2.126.667.666 1.336 1.079 2.126 1.384.766.296 1.636.499 2.913.558C8.333 23.988 8.74 24 12 24s3.667-.015 4.947-.072c1.277-.06 2.148-.262 2.913-.558.788-.306 1.459-.718 2.126-1.384.666-.667 1.079-1.335 1.384-2.126.296-.765.499-1.636.558-2.913.06-1.28.072-1.687.072-4.947s-.015-3.667-.072-4.947c-.06-1.277-.262-2.149-.558-2.913-.306-.789-.718-1.459-1.384-2.126C21.319.935 20.651.522 19.86.217c-.765-.297-1.636-.499-2.913-.558C15.667.012 15.26 0 12 0zm0 2.16c3.203 0 3.585.016 4.85.071 1.17.055 1.805.249 2.227.415.562.217.96.477 1.382.896.419.42.679.819.896 1.381.164.422.36 1.057.413 2.227.057 1.266.07 1.646.07 4.85s-.015 3.585-.074 4.85c-.061 1.17-.256 1.805-.421 2.227-.224.562-.479.96-.899 1.382-.419.419-.824.679-1.38.896-.42.164-1.065.36-2.235.413-1.274.057-1.649.07-4.859.07-3.211 0-3.586-.015-4.859-.074-1.171-.061-1.816-.256-2.236-.421-.569-.224-.96-.479-1.379-.899-.421-.419-.69-.824-.9-1.38-.165-.42-.359-1.065-.42-2.235-.045-1.26-.061-1.649-.061-4.844 0-3.196.016-3.586.061-4.861.061-1.17.255-1.814.42-2.234.21-.57.479-.96.9-1.381.419-.419.81-.689 1.379-.898.42-.166 1.051-.361 2.221-.421 1.275-.045 1.65-.06 4.859-.06l.045.03zm0 3.678c-3.405 0-6.162 2.76-6.162 6.162 0 3.405 2.76 6.162 6.162 6.162 3.405 0 6.162-2.76 6.162-6.162 0-3.405-2.76-6.162-6.162-6.162zM12 16c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4zm7.846-10.405c0 .795-.646 1.44-1.44 1.44-.795 0-1.44-.646-1.44-1.44 0-.794.646-1.439 1.44-1.439.793-.001 1.44.645 1.44 1.439z"/>
                        <?php elseif ($platform === 'linkedin'): ?>
                            <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                        <?php elseif ($platform === 'youtube'): ?>
                            <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                        <?php elseif ($platform === 'pinterest'): ?>
                            <path d="M12.017 0C5.396 0 .029 5.367.029 11.987c0 5.079 3.158 9.417 7.618 11.174-.105-.949-.199-2.403.041-3.439.219-.937 1.406-5.957 1.406-5.957s-.359-.72-.359-1.781c0-1.663.967-2.911 2.168-2.911 1.024 0 1.518.769 1.518 1.688 0 1.029-.653 2.567-.992 3.992-.285 1.193.6 2.165 1.775 2.165 2.128 0 3.768-2.245 3.768-5.487 0-2.861-2.063-4.869-5.008-4.869-3.41 0-5.409 2.562-5.409 5.199 0 1.033.394 2.143.889 2.741.099.12.112.225.085.345-.09.375-.293 1.199-.334 1.363-.053.225-.172.271-.402.165-1.495-.69-2.433-2.878-2.433-4.646 0-3.776 2.748-7.252 7.92-7.252 4.158 0 7.392 2.967 7.392 6.923 0 4.135-2.607 7.462-6.233 7.462-1.214 0-2.357-.629-2.75-1.378l-.748 2.853c-.271 1.043-1.002 2.35-1.492 3.146C9.57 23.812 10.763 24.009 12.017 24.009c6.624 0 11.99-5.367 11.99-11.988C24.007 5.367 18.641.001 12.017.001z"/>
                        <?php elseif ($platform === 'tiktok'): ?>
                            <path d="M19.59 6.69a4.83 4.83 0 0 1-3.77-4.245V2h-3.45v13.67a2.89 2.89 0 0 1-5.2 1.74 2.89 2.89 0 0 1 2.31-4.64 2.93 2.93 0 0 1 .88.13V9.4a6.84 6.84 0 0 0-1-.05A6.33 6.33 0 0 0 5 20.1a6.34 6.34 0 0 0 10.86-4.43v-7a8.16 8.16 0 0 0 4.77 1.52v-3.4a4.85 4.85 0 0 1-1-.1z"/>
                        <?php elseif ($platform === 'github'): ?>
                            <path d="M12 0c-6.626 0-12 5.373-12 12 0 5.302 3.438 9.8 8.207 11.387.599.111.793-.261.793-.577v-2.234c-3.338.726-4.033-1.416-4.033-1.416-.546-1.387-1.333-1.756-1.333-1.756-1.089-.745.083-.729.083-.729 1.205.084 1.839 1.237 1.839 1.237 1.07 1.834 2.807 1.304 3.492.997.107-.775.418-1.305.762-1.604-2.665-.305-5.467-1.334-5.467-5.931 0-1.311.469-2.381 1.236-3.221-.124-.303-.535-1.524.117-3.176 0 0 1.008-.322 3.301 1.23.957-.266 1.983-.399 3.003-.404 1.02.005 2.047.138 3.006.404 2.291-1.552 3.297-1.23 3.297-1.23.653 1.653.242 2.874.118 3.176.77.84 1.235 1.911 1.235 3.221 0 4.609-2.807 5.624-5.479 5.921.43.372.823 1.102.823 2.222v3.293c0 .319.192.694.801.576 4.765-1.589 8.199-6.086 8.199-11.386 0-6.627-5.373-12-12-12z"/>
                        <?php endif; ?>
                    </svg>
                </a>
            <?php endforeach; ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}

/**
 * Render Contact Form
 */
function wpdcsm_render_contact($data) {
    if (!$data['contact_enabled']) {
        return '';
    }
    
    ob_start();
    ?>
    <div class="wpdcsm-contact-wrapper">
        <?php if (!empty($data['contact_title'])): ?>
            <h3 class="wpdcsm-contact-title"><?php echo esc_html($data['contact_title']); ?></h3>
        <?php endif; ?>
        <?php if (!empty($data['contact_description'])): ?>
            <p class="wpdcsm-contact-description"><?php echo esc_html($data['contact_description']); ?></p>
        <?php endif; ?>
        <form class="wpdcsm-contact-form" id="wpdcsm-contact-form">
            <input type="text" name="name" class="wpdcsm-contact-name" placeholder="<?php echo esc_attr__('Your Name', 'dream-coming-soon'); ?>" required>
            <input type="email" name="email" class="wpdcsm-contact-email" placeholder="<?php echo esc_attr__('Your Email', 'dream-coming-soon'); ?>" required>
            <input type="text" name="subject" class="wpdcsm-contact-subject" placeholder="<?php echo esc_attr__('Subject', 'dream-coming-soon'); ?>">
            <textarea name="message" class="wpdcsm-contact-message" placeholder="<?php echo esc_attr__('Your Message', 'dream-coming-soon'); ?>" required></textarea>
            <button type="submit" class="wpdcsm-contact-button"><?php echo esc_html($data['contact_button_text']); ?></button>
            <div class="wpdcsm-contact-message-result"></div>
        </form>
    </div>
    <?php
    return ob_get_clean();
}

