<?php
namespace _8webit\Dragonfly\Frontend;


use _8webit\Dragonfly\Admin\Renderer\Font_Picker;
use _8webit\Dragonfly\Common\Options;

/**
 * Renders CSS for frontend
 * @since 1.0.0
 * @package _8webit\Dragonfly\Frontend
 */
class Style
{
    private static $suggestion_colors = [];
    private static $suggstion_hover_colors = [];

    public static function get(){
        self::$suggestion_colors = Options::get_suggestion_colors();
        self::$suggstion_hover_colors = Options::get_suggestion_hover_colors();

        $result = '';
        $result .= self::fullscreen();
        $result .= self::search_field();
        $result .= self::suggestion();
        $result .= self::title();
        $result .= self::category();
        $result .= self::price();
        $result .= self::sku();
        $result .= self::stock_status();

        return esc_html($result);
    }


    public static function css($selector, $properties, $append_properties_css = ''){
        $css = '';

        $css .= $selector . '{';

        foreach($properties as $property => $value){
            if(!empty($value)){
                $css .= $property . ':' . $value . ';';
            }
        }

        $css .= $append_properties_css;

        $css .= '}';

        return $css;
    }

    public static function search_field(){
        $field_colors = Options::get_field_colors();

        $selector = '.dragonfly .dragonfly-field';

        $properties = [
            'color'                =>  $field_colors['text'],
            'background-color'     =>  $field_colors['bg'],
            'border-color'         =>  $field_colors['border'],
            'border-radius'        => Options::get_field_border_radius() . 'px'
        ];

        $append = Font_Picker::get_css('search_field_font');

        $css = self::css($selector, $properties, $append);
        $css .= self::css('.dragonfly-icon-search', ['color' => $field_colors['icon']]);
        $css .= self::css('.dragonfly-menubar.active .dragonfly-icon-search', ['color' => $field_colors['active_icon']]);

        return $css;
    }

    public static function fullscreen(){
        $selector = '.dragonfly-fullscreen .dragonfly-container';
        $properties = [
            'background-color' => Options::get('fullscreen_bg')
        ];

        return self::css($selector, $properties);
    }

    public static function suggestion(){
        $selector = '.dragonfly .dragonfly-result';
        $properties = [
            'background-color' => Options::get('suggestion_bg_color')
        ];

        return self::css($selector, $properties);
    }

    public static function title(){
        $css = '';


        $selector = '.dragonfly .dragonfly-suggestion-title';
        $properties = [
            'color' => Options::get('suggestion_title_color')
        ];
        $append = Font_Picker::get_css('suggestion_title_font');


        $hover_properties = [
            'color' => Options::get('suggestion_hover_title_color')
        ];


        $css .= self::css($selector, $properties, $append);
        $css .= self::css($selector . ':hover', $hover_properties);

        return $css;
    }

    public static function thumbnail(){
        $selector = '.dragonfly .dragonfly-suggestion-thumbnail';
        $properties = [
            'border-radius' => Options::get_thubmnail_border_radius()
        ];

        return self::css($selector, $properties);
    }

    public static function price(){
        $css = '';

        $selector = '.dragonfly .dragonfly-suggestion-price';
        $properties = [
            'color' => Options::get('suggestion_price_color')
        ];
        $append = Font_Picker::get_css('suggestion_price_font');

        $hover_properties = [
            'color' => Options::get('suggestion_hover_price_color')
        ];

        $css .= self::css($selector, $properties, $append);
        $css .= self::css($selector . ':hover', $hover_properties);

        return $css;
    }

    public static function category(){
        $css = '';

        $selector = '.dragonfly .dragonfly-suggestion-category';
        $properties = [
            'color' => Options::get('suggestion_category_color')
        ];
        $append = Font_Picker::get_css('suggestion_category_font');

        $hover_properties = [
            'color' => Options::get('suggestion_hover_category_color')
        ];

        $css .= self::css($selector, $properties, $append);
        $css .= self::css($selector . ':hover', $hover_properties);

        return $css;
    }

    public static function sku(){
        $css = '';


        $selector = '.dragonfly .dragonfly-suggestion-sku';

        $properties = [
            'color' => Options::get('suggestion_sku_color')
        ];
        $append = Font_Picker::get_css('suggestion_sku_font');

        $hover_properties = [
            'color' => Options::get('suggestion_hover_sku_color')
        ];

        $css .= self::css($selector, $properties, $append);
        $css .= self::css($selector . ':hover', $hover_properties);

        return $css;
    }

    public static function stock_status(){
        $css = '';

        $selector = '.dragonfly .dragonfly-suggestion-stock_status';

        $properties = [
            'color' => Options::get('suggestion_sku_color')
        ];
        $append = Font_Picker::get_css('suggestion_sku_font');

        $hover_properties = [
            'color' => Options::get('suggestion_hover_sku_color')
        ];

        $css .= self::css($selector, $properties, $append);
        $css .= self::css($selector . ':hover', $hover_properties);

        return $css;
    }
}