<?php

namespace _8webit\Dragonfly\Common;

use _8webit\Dragonfly\Admin\Renderer\Font_Picker;

class Options{
    /**
     * Default option values
     * @var array
     */
    private static $defaults = [
        'search_by_title' => 'true',
        'search_by_sku' => 'true',
        'suggestion_count' => 4,
        'minimal_chars' => 3,
        'field_width' => 'auto',
        'placeholder' =>  'Search For...',
        'field_radius' =>  '2',
        'field_text_color' => '#000000',
        'field_bg_color' =>  '#ffffff',
        'field_border_color' =>  '#c3c3c3',
        'field_icon_color' =>  '#424242',
        'field_active_icon_color' =>  '#424242',
        'cat_lvl' => 1,
        'cat_count' => 1,
        'fullscreen_column' => 3,
        'suggestion_thumbnail_radius' => 2,
        'fullscreen_bg' => 'rgba(255, 255, 255, 0)',
        'suggestion_bg_color' => '#fafafa',
        'suggestion_title_color' => '#2196f3',
        'suggestion_price_color' => '#000000',
        'suggestion_category_color' => '#000000',
        'suggestion_sku_color' => '#000000',
        'suggestion_stock_status_color' => '#000000',
        'suggestion_hover_bg_color' => '#EEEEEE',
        'suggestion_hover_title_color' => '#000000',
        'suggestion_hover_price_color' => '#2196f3',
        'suggestion_hover_category_color' => '#2196f3',
        'suggestion_hover_sku_color' => '#2196f3',
        'suggestion_hover_stock_status_color' => '#2196f3'
        ];

    private static  $default_fonts = [
        'search_field_font' =>  array('"Arial Black", Gadget, sans-serif', 13, 'false', 'false'),
        'suggestion_title_font' =>  array('"Arial Black", Gadget, sans-serif', 24, 'true', 'false'),
        'suggestion_price_font' => array('"Arial Black", Gadget, sans-serif', 13, 'false', 'false'),
        'suggestion_category_font' => array('"Arial Black", Gadget, sans-serif', 13, 'false', 'false'),
        'suggestion_sku_font' => array('"Arial Black", Gadget, sans-serif', 13, 'false', 'false'),
        'suggestion_stock_status_font' => array('"Arial Black", Gadget, sans-serif', 13, 'false', 'false')
    ];

    /**
     * delete setting,
     * only used in uninstall.php
     *
     * @since 1.0.0
     *
     * @param $name
     */
    public static function delete($name){
        delete_option(DRAGONFLY::SETTINGS_PREFIX . $name);

        delete_site_option(
            DRAGONFLY::SETTINGS_PREFIX . $name
        );
    }

    /**
     * get_option() wrapper.
     * just adds plugin option prefix
     *
     * @since 1.0.0
     *
     * @param string $name
     * @return false|string
     */
    public static function get($name){
        $name = DRAGONFLY::SETTINGS_PREFIX . $name;

        $result = get_option($name);

        if($result === false && is_multisite()){
            $result = get_site_option($name);
        }
        return htmlentities($result);
    }

    /**
     * update_option() wrapper.
     * just adds plugin option prefix
     *
     * @since 1.0.0
     *
     * @param string $name
     * @return false|string
     */
    public static function set($name, $value){
        return update_site_option(DRAGONFLY::SETTINGS_PREFIX . $name, $value);
    }



    public static function set_defaults(){
        if(self::get('first_time_activated') === 'true'){
            return;
        }

        foreach(self::$defaults as $name => $value){
            self::set($name, $value);
        }

        foreach(self::$default_fonts as $name => $value){
            Font_Picker::set($name, $value);
        }

        self::set('suggestion_template', self::get_default_template());
        self::set('first_time_activated', 'true');
    }

	/**
	 * get searched post types.
	 * returns indexed array with 'arr_index' => 'post_type_name' pair
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
    public static function get_searched_post_types(){
        $result = [];

	    $args = [
		    'public' => true,
		    'publicly_queryable' => true
	    ];
	    if($post_type_names = get_post_types($args, 'names')) {
	    	foreach($post_type_names as $post_type_name){
	            if(self::get('search_for_post_type_'  . $post_type_name) === 'true'){
	            	$result[] = $post_type_name;
	            }
		    }
	    }

        return $result;
    }

	/**
	 * get searched taxonomies.
	 * returns indexed array with arr_index => tax_name pair
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
    public static function get_searched_taxs(){
        $result = [];

	    $args = [
		    'public' => true,
	    ];
	    if($tax_names = get_taxonomies($args, 'names')) {
		    foreach($tax_names as $tax_name){
			    if(self::get('search_for_tax_'  . $tax_name) === 'true'){
				    $result[] = $tax_name;
			    }
		    }
	    }

        return $result;
    }

	/**
	 * get data about how to search post type
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
    public static function get_searched_by(){
        $result = [];
        $is_woo_active = class_exists( 'woocommerce' );

        if(self::get('search_by_title') === 'true'){
            $result['title'] = true;
        }

        if($is_woo_active && self::get('search_by_sku') === 'true'){
            $result['sku'] = true;
        }

        return $result;
    }

	/**
	 * get search field placeholder
	 *
	 * @since 1.0.0
	 *
	 * @return false|string
	 */
    public static function get_placeholder(){
        return self::get('placeholder');
    }

    /**
     * gets html string of search suggestion template
     *
     * @since 1.0.0
     * @return mixed|string
     */
    public static function get_template(){
        return urldecode(self::get('suggestion_template'));
    }

	/**
	 * get suggestion count for query
	 *
	 * @since 1.0.0
	 *
	 * @return false|string
	 */
    public static function get_suggestion_count(){
        return self::get('suggestion_count');
    }

	/**
	 * get minimal chars for show suggestion
	 *
	 * @since 1.0.0
	 *
	 * @return false|string
	 */
    public static function get_minimal_chars(){
        return self::get('minimal_chars');
    }

	/**
	 * suggestion cattegory depth
	 *
	 * @since 1.0.0
	 *
	 * @return false|string
	 */
    public static function get_cat_lvl(){
        return self::get('cat_lvl');
    }

	/**
	 * get category count for single suggestion
	 *
	 * @since 1.0.0
	 *
	 * @return false|string
	 */
    public static function get_cat_count(){
        return self::get('cat_count');
    }

	/**
	 * returns asssociative array with 'property' => 'hex_color' pair
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
    public static function get_field_colors(){
        $result = [];

        $result['text'] = self::get('field_text_color');
        $result['bg'] = self::get('field_bg_color');
        $result['border'] = self::get('field_border_color');
        $result['icon'] = self::get('field_icon_color');
        $result['active_icon'] = self::get('field_active_icon_color');

        return $result;
    }

    public static function get_column_count(){
        return self::get('fullscreen_column');
    }

    public static function get_suggestion_colors(){
        $result = [];
        $result['body_bg'] = self::get('suggestion_body_bg_color');
        $result['bg'] = self::get('suggestion_bg_color');
        $result['title'] = self::get('suggestion_title_color');
        $result['price'] = self::get('suggestion_price_color');
        $result['category'] = self::get('suggestion_category_color');
        $result['sku'] = self::get('suggestion_sku_color');
        $result['stock_status'] = self::get('suggestion_stock_status_color');

        return $result;
    }

	/**
	 * returns asssociative array with 'property' => 'hex_color' pair
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
    public static function get_suggestion_hover_colors(){
        $result = [];

        $result['bg'] = self::get('suggestion_hover_bg_color');
        $result['title'] = self::get('suggestion_hover_title_color');
        $result['price'] = self::get('suggestion_hover_price_color');
        $result['category'] = self::get('suggestion_hover_category_color');
        $result['sku'] = self::get('suggestion_hover_sku_color');
        $result['stock_status'] = self::get('suggestion_hover_stock_status_color');

        return $result;
    }

    /**
     * get field border radius
     *
     * @since 1.0.0
     *
     * @return false|string
     */
    public static function get_field_border_radius(){
        return self::get('field_radius');
    }

    /**
     * get thumbnail border radius
     *
     * @since 1.0.0
     *
     * @return false|string
     */
    public static function get_thubmnail_border_radius(){
        return self::get('suggestion_thumbnail_radius');
    }

    /**
     * gets all registered fonts values
     * @since 1.0.0
     * @return array
     */
    public static function get_fonts(){
        $result = [];
        $result['title']        =  Font_Picker::get('search_field_font');
        $result['title']        =  Font_Picker::get('suggestion_title_font');
        $result['price']        =  Font_Picker::get('suggestion_price_font');
        $result['category']     =  Font_Picker::get('suggestion_category_font');
        $result['sku']          =  Font_Picker::get('suggestion_sku_font');
        $result['stock_status'] =  Font_Picker::get('suggestion_stock_status_font');

        return $result;
    }



    /**
     * encoded default html string for suggestion tempalte
     *
     * @since 1.0.0
     * @return string
     */
    private static function  get_default_template(){
        $thumbnail_url = get_site_url(null,'/wp-content/plugins/dragonfly/assets/admin/img/blank.png');

        $html = '';
        $html .= '<div class="dragonfly-row main-row">';

        $html .= '<div class="dragonfly-col dragonfly-col-2-2">';
        $html .= '<div id="dragonfly-suggestion-thubmnail" class="component">';
        $html .= '<img src="' . $thumbnail_url . '">';
        $html .= '</div>';// end of .component
        $html .= '</div>';// end of .dragonfly-col-2-2

        $html .= '<div class="dragonfly-row has-child-row">';
        $html .= '<div class="dragonfly-row">';
        $html .= '<div class="dragonfly-col"><p id="dragonfly-suggestion-title" class="component">Title</p></div>';
        $html .= '</div>';
        $html .= '</div>';

        $html .= '</div>';// end of .main-row

        return rawurlencode($html);
    }
}