<?php
namespace _8webit\Dragonfly\Common;

use _8webit\Dragonfly\Frontend\Style;

/**
 * Class Enqueue_Scripts
 * @package _8webit\Dragonfly\Common
 * @since 1.0.0
 */
class Enqueue_Scripts
{
    use _InstanceTrait;

	/**
	 * adds action for script enqueueing
	 *
	 * @since 1.0.0
	 */
    public static function init(){
        add_action('admin_enqueue_scripts', array(self::get_instance(), 'admin_scripts' ));
        add_action('wp_enqueue_scripts', array(self::get_instance(), 'frontend_scripts'));
    }

	/**
	 * enqueues admin script and style
	 *
	 * @since 1.0.0
	 */
    public function admin_scripts(){
    	if(get_current_screen()->base !== 'toplevel_page_dragonfly'){
    		return;
	    }

        $plugin_url = plugins_url('/dragonfly/');

        wp_enqueue_script(
            'dragonfly_admin_js',
            $plugin_url . 'dist/admin.bundle.js',
            array('jquery', 'jquery-ui-sortable', 'jquery-ui-slider')
        );

        wp_enqueue_style(
            'dragonfly_admin_css',
            $plugin_url . 'dist/admin.bundle.css'
        );

	    wp_localize_script(
		    'dragonfly_admin_js',
		    'dragonflySettings',
		    array(
			    'siteUrl' => get_site_url(),
			    'restUrl' => admin_url( 'admin-ajax.php' ),
			    'minLength' => Options::get_minimal_chars(),
			    'ajaxNonce' => wp_create_nonce('dragonfly_admin_nonce')
		    )
	    );
    }

	/**
	 * enqueues scripts and styles for frontend
	 *
	 * @since 1.0.0
	 */
    public function frontend_scripts(){
        $plugin_url = plugins_url('/dragonfly/');

        wp_enqueue_style(
            'dragonfly_public_css',
            $plugin_url . 'dist/public.bundle.css'
        );
        wp_add_inline_style(
            'dragonfly_public_css',
            Style::get()
        );

        wp_enqueue_script(
            'dragonfly_public_js',
            $plugin_url . 'dist/public.bundle.js',
            array(),
            '1.0',
            true
        );

        wp_localize_script(
            'dragonfly_public_js',
            'dragonflySettings',
            array(
                'siteUrl' => get_site_url(),
                'restUrl' => get_rest_url(),
                'template' => Options::get_template(),
                'minLength' => Options::get_minimal_chars(),
                'columnCount' => Options::get_column_count()
            )
        );
    }
}
