<?php
namespace _8webit\Dragonfly\Admin\Renderer;
use _8webit\Dragonfly\Admin\Menu;
use _8webit\Dragonfly\Common\DRAGONFLY;
use _8webit\Dragonfly\Common\Options;

/**
 * Renders html content for Dragonfly settings page
 *
 * used in @see Menu
 *
 * @package _8webit\Dragonfly\Admin\Renderer
 * @since 1.0.0
 */
class Settings {
	/**
	 * Renders html settings content for Dragonfly settings page
     *
     * @since 1.0.0
	 */
	public static function render(){
        ?>
		<div class="dragonfly-settings">
			<h2>Settings</h2>
			<?php
	        echo Collapsible_Box::render(
	            'general_settings',
	            __('General', DRAGONFLY::TEXT_DOMAIN),
	            self::general_settings_html()
	        );
            echo Collapsible_Box::render(
                'search_field_settings',
                __('Search Field', DRAGONFLY::TEXT_DOMAIN),
                self::search_field_settings()
            );
            echo Collapsible_Box::render(
                'suggestion_settings',
                __('Suggestion', DRAGONFLY::TEXT_DOMAIN),
                self::suggestion_settings_html()
            );
			?>
		</div>
		<?php
	}

	/**
     * gets general setting html string
     *
     * @since 1.0.0
     *
	 * @return string       html string
	 */
	private static function general_settings_html(){
		$html = '';

		$html .= self::search_for_box();

		$html .=  Form::form_group(
			'search_by_title',
			__('Search Post Type by Title or Description', DRAGONFLY::TEXT_DOMAIN),
			'checkbox'
		);

		// SKU - WooCommerce Only Field
        if(class_exists( 'woocommerce' )){
            $html .=  Form::form_group(
                'search_by_sku',
                __('Search product by SKU', DRAGONFLY::TEXT_DOMAIN),
                'checkbox'
            );
        }


		$html .=  Form::form_group(
			'minimal_chars',
			__('Minimal characters to show suggestion', DRAGONFLY::TEXT_DOMAIN),
			'number'
		);

		$html .=  Form::form_group(
			'suggestion_count',
			__('Count of suggestion to display', DRAGONFLY::TEXT_DOMAIN),
			'number'
		);

		return $html;
	}

	private static function search_field_settings(){
	    $html = '';
        $html .=  Form::form_group(
            'field_width',
            __('Width', DRAGONFLY::TEXT_DOMAIN),
            'text'
        );
        $html .=  Form::form_group(
            'field_radius',
            __('Field Radius', DRAGONFLY::TEXT_DOMAIN),
            'range'
        );

        $html .=  Form::form_group(
            'placeholder',
            __('Placeholder', DRAGONFLY::TEXT_DOMAIN),
            'text'
        );

        $html .= Collapsible_Box::render(
            'dragonfly-search-field-colors',
            __('Colors', DRAGONFLY::TEXT_DOMAIN),
            self::search_field_color_settings()
        );
        $html .= Font_Picker::render(
            'search_field_font',
            __('Font', DRAGONFLY::TEXT_DOMAIN)
        );
        return $html;
    }

    private static function suggestion_settings_html(){
	    $html = '';

        $html .= Form::form_group(
            'suggestion_bg_color',
            __('Background', DRAGONFLY::TEXT_DOMAIN),
            'color'
        );

        $html .= Form::form_group(
            'suggestion_hover_bg_color',
            __('Background on hover', DRAGONFLY::TEXT_DOMAIN),
            'color'
        );

        $html .=  Form::form_group(
            'fullscreen_column',
            __('Fullscreen mode Column Count', DRAGONFLY::TEXT_DOMAIN),
            'dropdown',
            array(
                1 => '1 Column',
                2 => '2 Columns',
                3 => '3 Columns',
                4 => '4 Columns'
            )
        );

        $html .= Form::form_group(
            'fullscreen_bg',
            'Full screen Mode Background',
            'color'
        );

        $html .= Collapsible_Box::render(
            'thumbnail_settings',
            __('Thumbnail', DRAGONFLY::TEXT_DOMAIN),
            self::thumbnail_settings_html()
        );

        $html .= Collapsible_Box::render(
            'title_settings',
            __('Title', DRAGONFLY::TEXT_DOMAIN),
            self::title_settings_html()
        );

        $html .= Collapsible_Box::render(
            'category_settings',
            __('Category', DRAGONFLY::TEXT_DOMAIN),
            self::category_settings_html()
        );


        // WooCommerce Components
        if(class_exists( 'woocommerce' )) {
            $html .= Collapsible_Box::render(
                'price_settings',
                __('Price', DRAGONFLY::TEXT_DOMAIN),
                self::price_settings_html()
            );

            $html .= Collapsible_Box::render(
                'sku_settings',
                __('SKU', DRAGONFLY::TEXT_DOMAIN),
                self::sku_settings_html()
            );

            $html .= Collapsible_Box::render(
                'stock_status_settings',
                __('Stock Status', DRAGONFLY::TEXT_DOMAIN),
                self::stock_status_settings_html()
            );
        }

        return $html;
    }

    /**
     * @since 1.0.0
     *
     * @return string
     */
    private static function thumbnail_settings_html(){
	    $html = '';

        $html .= Form::form_group(
            'suggestion_thumbnail_radius',
            __('Thumbnail Radius', DRAGONFLY::TEXT_DOMAIN),
            'range'
        );

        return $html;
    }

    /**
     * @since 1.0.0
     *
     * @return string
     */
    private static function title_settings_html(){
	    $html = '';
        $html .= Form::form_group(
            __( 'suggestion_title_color', DRAGONFLY::TEXT_DOMAIN),
            'Color ',
            'color'
        );

        $html .= Form::form_group(
            __( 'suggestion_hover_title_color', DRAGONFLY::TEXT_DOMAIN),
            'Color On Hover',
            'color'
        );

        $html .= Font_Picker::render(
            'suggestion_title_font',
            __('Font', DRAGONFLY::TEXT_DOMAIN)
        );

        return $html;
    }

    /**
     * @since 1.0.0
     *
     * @return string
     */
    private static function category_settings_html(){
	    $html = '';
        $html .=  Form::form_group(
            'cat_lvl',
            __('Count of Category Levels(depth) To Show', DRAGONFLY::TEXT_DOMAIN),
            'number'
        );

        $html .=  Form::form_group(
            'cat_count',
            __('Count Of Category To Show', DRAGONFLY::TEXT_DOMAIN),
            'number'
        );
        $html .= Form::form_group(
            'suggestion_category_color',
            __('Color ', DRAGONFLY::TEXT_DOMAIN),
            'color'
        );
        $html .= Form::form_group(
            'suggestion_hover_category_color',
            __(	'Category ', DRAGONFLY::TEXT_DOMAIN),
            'color'
        );
        $html .= Font_Picker::render(
            'suggestion_category_font',
            __('Font', DRAGONFLY::TEXT_DOMAIN)
        );
	    return $html;
    }

    private static function price_settings_html(){
	    $html = '';
        $html .= Form::form_group(
            __( 'suggestion_price_color', DRAGONFLY::TEXT_DOMAIN),
            'Color ',
            'color'
        );
        $html .= Form::form_group(
            __( 'suggestion_hover_price_color', DRAGONFLY::TEXT_DOMAIN),
            'Color On Hover ',
            'color'
        );
        $html .= Font_Picker::render(
            'suggestion_price_font',
            __('Price', DRAGONFLY::TEXT_DOMAIN)
        );

        return $html;
    }


    /**
     * @since 1.0.0
     *
     * @return string
     */
    private static function sku_settings_html(){
	    $html = '';

        $html .= Form::form_group(
            __( 'suggestion_sku_color', DRAGONFLY::TEXT_DOMAIN),
            'Color ',
            'color'
        );
        $html .= Form::form_group(
            __( 'suggestion_hover_sku_color', DRAGONFLY::TEXT_DOMAIN),
            'Color On Hover ',
            'color'
        );
        $html .= Font_Picker::render(
            'suggestion_sku_font',
            __('Font', DRAGONFLY::TEXT_DOMAIN)
        );
	    return $html;
    }

    /**
     * @since 1.0.0
     *
     * @return string
     */
    private static function stock_status_settings_html(){
	    $html = '';

        $html .= Form::form_group(
            'suggestion_stock_status_color',
            __('Color ', DRAGONFLY::TEXT_DOMAIN),
            'color'
        );
        $html .= Form::form_group(
            'suggestion_hover_stock_status_color',
            __('Color On Hover ', DRAGONFLY::TEXT_DOMAIN),
            'color'
        );
        $html .= Font_Picker::render(
            'suggestion_stock_status_font',
            __('Font', DRAGONFLY::TEXT_DOMAIN)
        );

	    return $html;
    }

	/**
     * gets html collapsible box string where options generated with
     * registered post type names and taxonomies
     *
     * use in
     * @see Settings::general_settings_html()
     *
     * @since 1.0.0
     *
	 * @return string  html string
	 */
	private static function search_for_box(){
	    $html = '';
	    $html .= self::search_for_post_types_box();
	    $html .= self::search_for_taxonomies_box();

	    return Collapsible_Box::render(
	            'search_for',
                __('Search For', DRAGONFLY::TEXT_DOMAIN),
                $html
        );
    }

	/**
     * gets html string collapsible box for post types
     *
     * @since 1.0.0
     *
	 * @return string
	 */
	private static function search_for_post_types_box(){
	    $html = '';
		$args = [
			'public' => true,
			'publicly_queryable' => true
		];

		if($post_types = get_post_types($args, 'objects')){
			foreach($post_types as $post_type){
				$html .=  Form::form_group(
					'search_for_post_type_' . $post_type->name,
					$post_type->label,
					'checkbox'
				);
			}
		}

		return Collapsible_Box::render('search_for_post_types', 'Post Types', $html);
    }

	/**
	 * gets html string collapsible box for post types
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
    private static  function search_for_taxonomies_box(){
	    $html = '';

	    $args = [
		    'public' => true,
	    ];

	    if($taxonomies = get_taxonomies($args, 'objects')){
		    foreach($taxonomies as $tax){
			    $html .=  Form::form_group(
				    'search_for_tax_' . $tax->name,
				    $tax->label,
				    'checkbox'
			    );
		    }
	    }

	    return Collapsible_Box::render('search_for_taxonomies', 'Taxonomies', $html);
    }


	/**
     * gets search field color settings html string
     *
     * @since 1.0.0
     *
	 * @return string   html string
	 */
	private static function search_field_color_settings(){
		$html = '';
		$html .= Form::form_group(
			'field_bg_color',
			__('Background ', DRAGONFLY::TEXT_DOMAIN),
			'color'
		);
		$html .= Form::form_group(
			__( 'field_text_color', DRAGONFLY::TEXT_DOMAIN),
			'Text ',
			'color'
		);
		$html .= Form::form_group(
			'field_border_color',
			__('Border ', DRAGONFLY::TEXT_DOMAIN),
			'color'
		);
		$html .= Form::form_group(
			'field_icon_color',
			__('Icon ', DRAGONFLY::TEXT_DOMAIN),
			'color'
		);
        $html .= Form::form_group(
            'field_active_icon_color',
            __('Icon Color When Field Is Active', DRAGONFLY::TEXT_DOMAIN),
            'color'
        );
		return $html;
	}
}