<?php
namespace _8webit\Dragonfly\Admin\Renderer;

use _8webit\Dragonfly\Common\DRAGONFLY;
use _8webit\Dragonfly\Common\Options;

/**
 * Fields Renderers
 *
 * @package _8webit\Dragonfly\Admin\Renderer
 * @since 1.0.0
 */
class Form {
    /**
     * returns html string of input,
     * id and name will be same
     *
     * @param string $name             unique name for input
     * @param string $value            value for input
     * @param string $type             html input type
     * @return string           html string
     */
    public static function input($name, $value, $type){
        return '<input id="' . $name . '" value="' . $value . '" type="' . $type . '" name="' . $name  . '">';
    }

    /**
     * return html string of checkbox field
     *
     * @since  1.0.0
     *
     * @param string $name        input name
     * @param string $value      if value set to true field will be checked,
     *
     * @return string           html string  of  input, type color
     */
	 public static  function checkbox($name, $value){
         $checked = $value === 'true' ? 'checked="checked"' : '';
         return '<input id="' . $name . '" value="true" type="checkbox" name="' . $name  . '" ' . $checked . '>';
    }

    /**
     * return html string of color field
     *
     * @since  1.0.0
     *
     * @param string $name        input name
     * @param string $value       input value
     *
     * @return string           html string  of  input, type color
     */
    public static function  color($name, $value){
        return '<input id="' . $name . '" value="' . $value . '" type="text" name="' . $name  . '" class="spectrum">';
    }


    /**
     * get html string of dropdown field
     *
     * @sicne 1.0.0
     *
     * @param string $name
     * @param string $value
     * @param array $options
     * @return string
     */
    private static function dropdown($name, $value, $options)
    {
        $html = '<select id="' .  $name . '" name="' . $name . '">';

        foreach ($options as $key => $option){
            $html .= '<option value="' . $key . '"';

            if($value == $key){
                $html .= ' selected="selected"';
            }

            $html .= '>';
            $html .= $option;
            $html .= '</option>';
        }

        $html .= '</select>';

        return $html;
    }

    /**
     * gets string html  field with label and field
     *
     * @since 1.0.0
     *
     * @param string $name       html field name attribute
     * @param string $label     field label
     * @param string $type      checkbox | color | dropdown | range or other html field type
     * @param array $values     associative array
     *
     * @return string   html string
     */
    public static  function form_group($name, $label, $type, $values = array()){

        $value = Options::get($name);

        $prefixed_name = DRAGONFLY::SETTINGS_PREFIX . $name;

        $html = '';
        $html .= '<div class="setting">';
        $html .= '<div class="label-wrapper">';

        if(!empty($label)){
            $html .= '<label for="' . $prefixed_name . '">';
            $html .= $label;
            $html .= '</label>';
        }

        $html .= '</div>';

        $html .= '<div class="field-wrapper">';
        switch($type){
            case 'checkbox':
                $html .= self::checkbox($prefixed_name, $value);
                break;
            case 'color':
                $html .= self::color($prefixed_name, $value);
                break;
            case 'dropdown':
                $html .= self::dropdown($prefixed_name,$value, $values);
                break;
            case 'range':
                $html .= self::range($prefixed_name, $value);
                break;
            default:
                $html .= self::input($prefixed_name, $value, $type);
		}
        $html .= '</div>';
        $html .= '</div>';

        return $html;
    }

    public static function range($name, $value){
        $html = '';
        $html .= self::input($name, $value, 'range');
        return $html;
    }
}