<?php
/**
 * Created by PhpStorm.
 * User: zero
 * Date: 6/4/18
 * Time: 3:33 PM
 */

namespace _8webit\Dragonfly\Admin\Renderer;


use _8webit\Dragonfly\Common\Options;
use _8webit\Dragonfly\Common\DRAGONFLY;
use _8webit\Dragonfly\Common\Sanitize;

/**
 * font picker renderer for dragonfly settings
 *
 * @package _8webit\Dragonfly\Admin\Renderer
 * @since 1.0.0
 */
class Font_Picker {
    /**
     * gets font familly options in associative array
     *
     * @since 1.0.0
     *
     * @param string $name Option prefix(base name)
     * @return array
     */
    public static function get($name){
        $result = [];
        $result['family'] = Options::get($name . '_family');
        $result['size'] = Options::get($name . '_size');
        $result['bold'] = Options::get($name . '_bold');
        $result['italic'] = Options::get($name . '_italic');

        return $result;
    }

    /**
     * font options to css properties
     *
     * @since 1.0.0
     *
     * @param string $name Option prefix(base name)
     * @return string
     */
    public static function get_css($name){
        $bold = Options::get($name . '_bold')  === 'true' ? 'bold' : 'normal';
        $italic = Options::get($name . '_italic') === 'true' ? 'italic' : 'normal';

        $result = '';
        $result .= 'font-family:' . Options::get($name . '_family') . ';' ;
        $result .= 'font-size:' . Options::get($name . '_size') . 'px;' ;
        $result .= 'font-weight:' . $bold . ';' ;
        $result .= 'font-style:' . $italic . ';' ;

        return $result;
    }

	/**
	 * gets font picker html
	 *
	 * @param string $name     base option name
	 * @param string $label    label for font picker
	 *
	 * @return string   html string
	 */
	public static function render($name, $label){
		$html = '';

		$html .= Form::form_group( $name . '_family', 'Font Family', 'text');
		$html .= Form::form_group( $name . '_size', 'Size', 'number');
		$html .= Form::form_group( $name . '_bold', 'Bold', 'checkbox');
		$html .= Form::form_group( $name . '_italic', 'Italic', 'checkbox');

		$html = Collapsible_Box::render( $name . '_box', $label, $html);

		return $html;
	}

    /**
     * registers seperate settings for font family,
     * font size, font weight and style with prefix.
     *
     * defaults parameter indexed array sequence is
     * array('family', 'size', 'isBold', 'isItalic')
     *
     * @since 1.0.0
     *
     * @param string $name Option prefix(base name)
     * @param array $defaults   indexed array
     */
	public static function register_settings($name){
		register_setting(
			DRAGONFLY::SETTINGS_GROUP,
			DRAGONFLY::SETTINGS_PREFIX . $name . '_family'
		);
		register_setting(
			DRAGONFLY::SETTINGS_GROUP,
			DRAGONFLY::SETTINGS_PREFIX . $name . '_size'
		);
		register_setting(
			DRAGONFLY::SETTINGS_GROUP,
			DRAGONFLY::SETTINGS_PREFIX . $name . '_bold'
		);
		register_setting(
			DRAGONFLY::SETTINGS_GROUP,
			DRAGONFLY::SETTINGS_PREFIX . $name . '_italic'
		);
	}

    /**
     * deletes option for font family,
     * font size, font weight and style with prefix.
     * only used in uninstall.php
     *
     * @since 1.0.0
     *
     * @param $name
     */
    public static function delete_option($name){
        Options::delete($name . '_family');
        Options::delete($name . '_size');
        Options::delete($name . '_bold');
        Options::delete($name . '_italic');
    }


    public static function set($name, $value){
        Options::set($name . '_family', $value[0]);
        Options::set($name . '_size', $value[1]);
        Options::set($name . '_bold', $value[2]);
        Options::set($name . '_italic', $value[3]);
    }
}