<?php
namespace _8webit\Dragonfly\Admin\Renderer;

/**
 * Class CollapsibleBox
 * @package _8webit\Dragonfly\Admin\Renderer
 * @since 1.0.0
 */
class Collapsible_Box{
	/**
	 * render collapsible box
	 *
	 * @param string $id
	 * @param string $title
	 * @param string $content  html string
	 *
	 * @return string
	 */
	public static function render($id, $title, $content){
		$html = '';
		$html .= '<div id="' . $id . '" class="collapsible-box" >';
		$html .= '<div class="header-wrapper">';
		$html .= '<h1 class="title">' . $title . '</h1>';
		$html .= '<div class="collapse-toggle">';
		$html .= '<span class="dashicons dashicons-arrow-down"></span>';
		$html .= '</div>';
		$html .= '</div>';
		$html .= '<div class="inner-content">';
		$html .= $content;
		$html .= '</div>';
		$html .= '</div>';
		return $html;
	}
}