<?php
namespace _8webit\Dragonfly\Admin;

use _8webit\Dragonfly\Admin\Renderer\Font_Picker;

use _8webit\Dragonfly\Common\_InstanceTrait;
use _8webit\Dragonfly\Common\DRAGONFLY;

/**
 * Dragonfly settings
 *
 * @package _8webit\Dragonfly\Admin
 * @sice 1.0.0
 */
class Register_Settings{
    use _InstanceTrait;

	/**
	 * adds action hook for registering settings for Dragonfly plugin
	 * @since 1.0.0
	 */
    public static function init(){
        add_action( 'admin_init', array(self::get_instance(), 'register_settings' ));
    }

    /**
     * registers single settings with Dragonfly setting prefix
     *
     * @since 1.0.0
     *
     * @param $name
     * @param string $default
     */
    private function register_setting($name){
         register_setting(
            DRAGONFLY::SETTINGS_GROUP,
            DRAGONFLY::SETTINGS_PREFIX . $name
        );
    }

	/**
	 * registers settings for Dragonfly plugin
	 *
	 * @since 1.0.0
	 */
    public function register_settings(){
        $this->general();
        $this->field();
        $this->suggestion();
    }

    /**
     * registers general settings
     *
     * @since 1.0.0
     */
    private function general(){
        $this->search_for_post_types();

        $this->search_for_terms();

        $this->register_setting('first_time_activated');

        $this->register_setting('search_by_title');
        $this->register_setting('search_by_sku');
        $this->register_setting('suggestion_count');
        $this->register_setting('minimal_chars');
    }

    /**
     * registers settings for which post types to search for.
     *
     * @since 1.0.0
     */
    private function search_for_post_types(){
        $args = [
            'public' => true,
            'publicly_queryable' => true
        ];

        if($post_types = get_post_types($args, 'objects')){
            foreach($post_types as $post_type){
                $this->register_setting('search_for_post_type_' . $post_type->name);
            }
        }
    }

    /**
     * registers settings for which terms to search for.
     *
     * @since 1.0.0
     */
    private function search_for_terms(){
        $args = [
            'public' => true
        ];

        if($taxonomies = get_taxonomies($args, 'objects')){
            foreach($taxonomies as $taxonomy){
                $this->register_setting('search_for_tax_' . $taxonomy->name, false);
            }
        }
    }

    /**
     * registers settings for field
     *
     * @since 1.0.0
     */
    private function field(){
        $this->register_setting('field_width');
        $this->register_setting('placeholder');
        $this->register_setting('field_radius');

        // Colors
        $this->register_setting('field_text_color');
        $this->register_setting('field_bg_color');
        $this->register_setting('field_border_color');
        $this->register_setting('field_icon_color');
        $this->register_setting('field_active_icon_color');
        // Font
        Font_Picker::register_settings(
            'search_field_font'
        );
    }

    /**
     * registers settings for suggestion
     *
     * @since 1.0.0
     */
    private function suggestion(){
        $this->register_setting('cat_lvl');
        $this->register_setting('cat_count');
        $this->register_setting('fullscreen_column');

        $this->register_setting('suggestion_template');
        $this->register_setting('suggestion_thumbnail_radius');

        $this->register_setting('fullscreen_bg');
        $this->register_setting('suggestion_bg_color');
        $this->register_setting('suggestion_title_color');
        $this->register_setting('suggestion_price_color');
        $this->register_setting('suggestion_category_color');
        $this->register_setting('suggestion_sku_color');
        $this->register_setting('suggestion_stock_status_color');

        $this->register_setting('suggestion_hover_bg_color');
        $this->register_setting('suggestion_hover_title_color');
        $this->register_setting('suggestion_hover_price_color');
        $this->register_setting('suggestion_hover_category_color');
        $this->register_setting('suggestion_hover_sku_color');
        $this->register_setting('suggestion_hover_stock_status_color');


        Font_Picker::register_settings('suggestion_title_font');

        Font_Picker::register_settings('suggestion_price_font');
        Font_Picker::register_settings('suggestion_category_font');
        Font_Picker::register_settings('suggestion_sku_font');
        Font_Picker::register_settings('suggestion_stock_status_font');
    }
}