<?php
namespace _8webit\Dragonfly\Admin;

use _8webit\Dragonfly\Admin\Renderer\Search_Field_Demos;
use _8webit\Dragonfly\Common\_InstanceTrait;
use _8webit\Dragonfly\Common\DRAGONFLY;

use _8webit\Dragonfly\Admin\Renderer\Settings as Settings_Renderer;
use _8webit\Dragonfly\Admin\Renderer\Customizer as Customizer_Renderer;
use _8webit\Dragonfly\Common\Options;

/**
 * Class Menu
 * @package _8webit\Dragonfly\Admin
 * @since 1.0.0
 */
class Menu{
	use _InstanceTrait;

	/**
     * adds action hook for registering Dragonfly setting menu page
     *
	 * @since 1.0.0
	 */
	public static function init(){
		add_action( 'admin_menu', array(self::get_instance(), 'add_menu') );
	}


	/**
	 * registers Dragonfly settings menu page
     *
     * @since 1.0.0
	 */
	public function add_menu(){
        add_menu_page(
            'Dragonfly',
            'Dragonfly',
            'manage_options',
            'dragonfly',
            array(self::get_instance(), 'page_content'),
            plugins_url('/dragonfly/assets/admin/img/menu-icon.png')
        );
	}

	/**
     * renders content for Dragonfly settings page
     *
	 * @since 1.0.0
	 */
	public function page_content(){
		?>
		<div class="wrap">
			<div class="codename">
                <img src="<?php echo plugins_url('/dragonfly/assets/admin/img/logo.png') ?>"  alt="" class="logo">
            </div>
            <?php settings_errors( DRAGONFLY::SETTINGS_GROUP ); ?>

            <form method="post" action="options.php" autocomplete="off">
				<?php settings_fields( DRAGONFLY::SETTINGS_GROUP ); ?>
				<?php do_settings_sections( DRAGONFLY::SETTINGS_GROUP ); ?>

                <div class="settings">
                    <?php Settings_Renderer::render();?>

                    <div class="demo_n_customizer">
                        <h2>Live Preview</h2>
                        <?php Search_Field_Demos::render(); ?>
                        <?php Customizer_Renderer::render(); ?>
                    </div>
                </div>
				<?php submit_button(); ?>

                <div class="copyright">
                    <a href="https://8webit.com" target="_blank">&#169; 2018 - Developed by <span class="underline">8webit</span></a>
                </div>
			</form>
		</div>
		<?php
	}
}