<?php
/*
Plugin Name:  Dragonfly
Plugin URI:   https://8webit.com/dragonfly
Description:  Ultimate Wordpress Search Plugin That Can Search Any Post Type Or Taxonomy
Version:      1.0.0
Author:       8webit
Author URI:   https://8webit.com/
License:      GPL2
License URI:  https://www.gnu.org/licenses/gpl-2.0.html
Text Domain:  dragonfly

WC requires at least: 2.2.0
WC tested up to: 3.4.5
*/

if ( ! defined( 'ABSPATH' ) ) {
exit;
}

require_once 'vendor/autoload.php';

use _8webit\Dragonfly\Admin\Renderer\Font_Picker;
use _8webit\Dragonfly\Common\Enqueue_Scripts;

use _8webit\Dragonfly\Admin\Menu;

use _8webit\Dragonfly\Admin\Register_Settings;

use _8webit\Dragonfly\Common\Options;
use _8webit\Dragonfly\Frontend\Rest\Search;
use _8webit\Dragonfly\Frontend\Shortcode;

Enqueue_Scripts::init();
Menu::init();
Register_Settings::init();
Search::init();
Shortcode::init();

/**
 * adds settings link to Dragonfly plugin in plugins page
 *
 * @since 1.0.0
 *
 * @param $links
 *
 * @return array
 */
function dragonfly_add_action_links ( $links ) {
    $mylinks = array(
        '<a href="' . admin_url( 'options-general.php?page=dragonfly' ) . '">Settings</a>',
    );
    return array_merge( $mylinks,$links );
}
add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'dragonfly_add_action_links' );



/**
 * plugin activation hook
 *
 * @since 1.0.0
 *
 */
register_activation_hook(__FILE__, 'dragonfly_activate');
function dragonfly_activate(){
    Options::set_defaults();
}
