import {initSearchField} from "../../common/js/search";
import {renderMenubarField} from "../../common/js/inline-field";
import {renderFullscreenMode} from "../../common/js/fullscreen";
import {setSearchFieldElement} from "../../admin/js/common";

document.addEventListener('DOMContentLoaded', function() {
    var menuBarField = document.querySelector('.dragonfly-inline-field');
    var fullscreenmode= document.querySelector('.dragonfly-fullscreen');

    if(menuBarField){
        renderMenubarField(menuBarField);
    }

    if(fullscreenmode){
        renderFullscreenMode(fullscreenmode);
    }

    setSearchFieldElement();

    initFields();
});

function initFields(){
    var elements = document.querySelectorAll('.dragonfly-field');
    if(elements){
        for(var i=0; i < elements.length; i++){
            initSearchField(elements[i]);
        }
    }
}


