/**
 * inserts inline css after head
 *
 * @since 1.0.0
 *
 * @param selector  css selector
 * @param prop      css property
 * @param value     css property value
 * @param state     css state
 */
export function jscss(selector, prop, value, state){
    var css = '';
    var sheet_id = selector.substring(1);

    state = state ? state : '';
    selector = state !== '' ? selector + ':' + state: selector;

    if(state !== ''){
        sheet_id += '_' + state;
    }

    var stylesheet = $('head').find('#' + sheet_id);

    if(stylesheet.length > 0){
        css = stylesheet.text();

        if(css.indexOf(selector) < 0){
            css += selector + '{' + prop + ':' + value + ';}';
        }else{
            var startIndex = css.indexOf('{', css.indexOf(selector)) + 1;
            var endIndex = css.indexOf('}', css.indexOf(selector));
            var rules = css.substring(startIndex, endIndex);

            rules = rules.split(';');
            rules = rules.filter(function(val){
                return val !== "";
            });

            if(rules.length > 0){
                var found = false;
                for(var i = 0; i < rules.length ; i++){
                    if(rules[i].indexOf(prop) >= 0){
                        found = true;
                        rules[i] = prop + ':' + value;
                    }
                }

                if(!found){
                    rules.push(prop + ':' + value );
                }

                rules = rules.join(';');
                rules += ';';
            }else{
                rules = prop + ':' + value + ';';
            }
            var selectorIndex = css.indexOf(selector);
            var replace = css.slice(
                selectorIndex,
                css.indexOf('}', selectorIndex) + 1
            );
            css = css.replace(replace, selector + '{' + rules + '}');
        }

        stylesheet.text(css);
    }else{
        css +=  selector + '{' + prop + ':' + value + ';}';

        $('head').append(
            $('<style/>',{
                id: sheet_id,
                type: 'text/css',
                text: css
            })
        );
    }
}