/**
 * renders menu bar field
 *
 * @since 1.0.0
 *
 * @param userHandler       field handler
 */
export function renderMenubarField(userHandler){
    var div = document.createElement('div');
    div.setAttribute('class', 'dragonfly dragonfly-inline');

    var handlers = document.createElement('p');
    handlers.setAttribute('class', 'dragonfly-handler');
    handlers.innerHTML = userHandler.outerHTML;

    // userHandler does not have dragonfly icon render it
    if(!userHandler.classList.contains('dragonfly-icon-search')){
        var dragonflyHandler  = document.createElement('i');
        dragonflyHandler.setAttribute('class', 'dragonfly-icon-search dragonfly-inline-field');
        dragonflyHandler.setAttribute('style', 'display:none;');
        handlers.appendChild(dragonflyHandler);
    }

    var fieldWrapper = document.createElement('div');
    fieldWrapper.setAttribute('class', 'dragonfly-field-wrapper');

    var falseDiv = document.createElement('div');

    var field = document.createElement('input');
    field.setAttribute('class', 'dragonfly-field');
    field.setAttribute('type', 'text');

    falseDiv.appendChild(field);
    fieldWrapper.appendChild(falseDiv);

    div.appendChild(handlers);
    div.appendChild(fieldWrapper);

    userHandler.parentNode.insertBefore(div, userHandler);
    userHandler.parentNode.removeChild(userHandler);

    events(handlers);
}

/**
 * events for menu bar field
 *
 * @since 1.0.0
 */
function events(handlers){
    handlers.addEventListener('click', function(e){
        e.preventDefault();

        var topParent = e.target.parentNode.parentNode; // .dragonfly-inline
        var searchField = topParent.querySelector('.dragonfly-field');
        var searchResults = topParent.querySelector('.dragonfly-results');

        if(searchField.style.display === 'block'){
            if(handlers.children.length === 2){
                handlers.children[0].style.display = 'block'; // users handler
                handlers.children[1].style.display = 'none'; // dragonfly handler
            }

            topParent.classList.remove('active');
            searchField.style.display = 'none';

            if(searchResults){
                searchResults.style.display = 'none';
            }
        }else{
            if(handlers.children.length === 2){
                handlers.children[0].style.display = 'none'; // users handler
                handlers.children[1].style.display = 'block'; // dragonfly handler
            }
            topParent.classList.add('active');
            searchField.style.display = 'block';

            if(searchResults) {
                searchResults.style.display = 'none';
            }
        }
    });
}