/**
 * Returns an array with arrays of the given size.
 *
 * @param arr {Array} array to split
 * @param chunk_size Size of every group
 */
export function chunkArray(arr, chunk_size){
    var resultArray = [];
    for (var index = 0; index < arr.length; index += chunk_size) {
        resultArray.push( arr.slice(index, index+chunk_size));
    }

    return resultArray;
}

/**
 * checks if element has any parent with given class
 * @param element       child element
 * @param className     parents class
 * @returns {boolean}
 */
export function hasParent(element, className) {
    do {
        if (element.classList && element.classList.contains(className)) {
            return true;
        }
        element = element.parentNode;
    } while (element);
    return false;
}