export  function renderFullscreenMode(handler){
    renderHtml();
    events(handler);
}

/**
 * renders html for fullscreen mode
 *
 * @since 1.0.0
 */
function renderHtml() {
    var target = document.querySelector('body');
    var result = document.createElement('div');

    var classAttr =  'dragonfly dragonfly-fullscreen';
    classAttr += dragonflySettings.columnCount  ? ' dragonfly-column-' + dragonflySettings.columnCount : '';
    result.setAttribute('class',classAttr);

    var crossIcon = document.createElement('p');
    crossIcon.setAttribute('class', 'dragonfly-icon-cross');

    var container = document.createElement('div');
    container.setAttribute('class', 'dragonfly dragonfly-container');

    var wrapper = document.createElement('div');
    wrapper.setAttribute('class', 'dragonfly dragonfly-wrapper');

    var searchIcon = document.createElement('p');
    searchIcon.setAttribute('class', 'dragonfly-icon-search');

    var field = document.createElement('input');
    field.setAttribute('class', 'dragonfly-field');
    field.setAttribute('type', 'text');


    wrapper.appendChild(searchIcon);
    wrapper.appendChild(field);

    container.appendChild(wrapper);

    result.appendChild(crossIcon);
    result.appendChild(container);

    target.insertBefore(result, target.firstChild);
}

/**
 * hooks events for fullscreen mode
 */
function events(handler){
    var element = document.querySelector('.dragonfly-fullscreen');
    var crossIcon = element.querySelector('.dragonfly-icon-cross');

    handler.addEventListener('click', function (e) {
        e.preventDefault();

        if(element){
            element.style.display = showPopup();
        }
    });

    crossIcon.addEventListener('click', function(){
       element.style.display = element.style.display === 'none' ? showPopup() : hidePopup();
    });

    window.onkeydown = function( event ) {
       if(event.key === 'Escape'){
           element.style.display = hidePopup();
       }
    };
}

/**
 * shows fullscreen popup for search
 * @since 1.0.0
 */
function showPopup(){
    document.querySelector('body').classList.add('dragonfly-fullscreen-active');
    document.querySelector('.dragonfly-fullscreen').style.display = 'block';
}

/**
 * hides fullscreen popup for search
 *
 * @since 1.0.0
 */
function hidePopup(){
    document.querySelector('body').classList.remove('dragonfly-fullscreen-active');
    document.querySelector('.dragonfly-fullscreen').style.display = 'none';
}