import {setComponentsElement, setCustomizerElement} from "./common";

import {loadFromOption} from "./customizer/helpers";
import {initUiSortable} from "./customizer/init-ui-sortable";

import {initGeneralOptions} from "./live-options/general-options";
import {spectrum} from "./live-options/spectrum";
import {initSearch} from "./live-options/init-search";
import {marryFontPickers} from "./live-options/marry";
import {collapsibleBox} from "./collapsible-box";

$(document).ready(function () {
    setCustomizerElement();
    setComponentsElement();

    collapsibleBox();

    // Customizer
    loadFromOption();
    initUiSortable();
    
    //Live options
    initSearch();
    initGeneralOptions();
    spectrum();
    marryFontPickers();
});