import {jscss} from "../../../common/js/jscss";
import {optionPrefix, searchField} from "../common";

export function marryColors(optionID, color){
    optionID = optionID.replace(optionPrefix, '');

    var found;

    found =  marryFieldSettings(optionID, color);

    if(!found){
        found = marrySuggestionSettings(optionID, color);
    }

    if(!found){
        marrySuggestionHoverSettings(optionID, color);
    }
}

export function marryFieldSettings(optionID, value){
    switch (optionID){
        case 'field_bg_color':
            searchField.css('background-color', value);
            break;
        case 'field_text_color':
            searchField.css('color', value);
            break;
        case 'field_border_color':
            searchField.css('border-color', value);
            break;
        case 'field_icon_color':
            jscss('.dragonfly-icon-search','color', value);
            break;
        case 'field_active_icon_color':
            jscss('.dragonfly-menubar.active .dragonfly-icon-search', 'color', value);
        default:
            return false;
    }

    return true;
}

export function marrySuggestionSettings(optionID, value){
    switch (optionID){
        case 'fullscreen_bg':
            $('.dragonfly-container').css('background-color', value);
            break;
        case 'suggestion_bg_color':
            jscss('#dragonfly-suggestion-customizer', 'background-color', value);
            jscss('.dragonfly-result', 'background-color', value);
            break;
        case 'suggestion_title_color':
            jscss('#dragonfly-suggestion-title', 'color', value);
            jscss('.dragonfly-suggestion-title', 'color', value);
            break;
        case 'suggestion_category_color':
            jscss('#dragonfly-suggestion-cat', 'color', value);
            jscss('.dragonfly-suggestion-cat', 'color', value);
            break;
        case 'suggestion_price_color':
            jscss('#dragonfly-suggestion-price', 'color', value);
            jscss('.dragonfly-suggestion-price', 'color', value);
            break;
        case 'suggestion_sku_color':
            jscss('#dragonfly-suggestion-sku', 'color', value);
            jscss('.dragonfly-suggestion-sku', 'color', value);
            break;
        case 'suggestion_stock_status_color':
            jscss('#dragonfly-suggestion-stock-status', 'color', value);
            jscss('.dragonfly-suggestion-stock-status', 'color', value);
            break;
        default:
            return false;
    }

    return true;
}

function marrySuggestionHoverSettings(optionID, value){
    switch (optionID){
        case 'suggestion_hover_bg_color':
            jscss('#dragonfly-suggestion-customizer', 'background-color', value, 'hover');
            jscss('.dragonfly-result', 'background-color', value, 'hover');
            break;
        case 'suggestion_hover_title_color':
            jscss('#dragonfly-suggestion-title', 'color', value, 'hover');
            jscss('.dragonfly-suggestion-title', 'color', value, 'hover');
            break;
        case 'suggestion_hover_category_color':
            jscss('#dragonfly-suggestion-cat', 'color', value, 'hover');
            jscss('.dragonfly-suggestion-cat', 'color', value, 'hover');
            break;
        case 'suggestion_hover_price_color':
            jscss('#dragonfly-suggestion-price', 'color', value, 'hover');
            jscss('.dragonfly-suggestion-price', 'color', value, 'hover');
            break;
        case 'suggestion_hover_sku_color':
            jscss('#dragonfly-suggestion-sku', 'color', value, 'hover');
            jscss('.dragonfly-suggestion-sku', 'color', value, 'hover');
            break;
        case 'suggestion_hover_stock_status_color':
            jscss('#dragonfly-suggestion-stock-status', 'color', value, 'hover');
            jscss('.dragonfly-suggestion-stock-status', 'color', value, 'hover');
            break;
        default:
            return false;
    }
    return true;
}

export function marryFontPickers(){
    marryFontPicker(
        optionPrefix + 'search_field_font',
        ['.dragonfly-field']
    );
    marryFontPicker(
        optionPrefix + 'suggestion_title_font',
        ['#dragonfly-suggestion-title', '.dragonfly-suggestion-title']
    );
    marryFontPicker(
        optionPrefix + 'suggestion_price_font',
        ['#dragonfly-suggestion-price', '.dragonfly-suggestion-price']
    );
    marryFontPicker(
        optionPrefix + 'suggestion_category_font',
        ['#dragonfly-suggestion-cat', '.dragonfly-suggestion-cat']
    );
    marryFontPicker(
        optionPrefix + 'suggestion_sku_font',
        ['#dragonfly-suggestion-sku', '.dragonfly-suggestion-sku']
    );
    marryFontPicker(
        optionPrefix + 'suggestion_stock_status_font',
        ['#dragonfly-suggestion-stock-status', '.dragonfly-suggestion-stock-status']
    );
}

export function marryFontPicker(name, partners){
    $('#' + name + '_family').each(function(){
        $(this).change(function(){
            for(var i = 0; i < partners.length; i++){
                jscss(partners[i], 'font-family', $(this).val());
            }
        });

        for(var i = 0; i < partners.length; i++){
            jscss(partners[i], 'font-family', $(this).val());
        }
    });
    $('#' + name + '_size').each(function(){
        $(this).change(function(){
            for(var i = 0; i < partners.length; i++){
                jscss(partners[i], 'font-size', $(this).val() + 'px');
            }
        });

        for(var i = 0; i < partners.length; i++){
            jscss(partners[i], 'font-size', $(this).val() + 'px');
        }
    });
    $('#' + name + '_bold').each(function(){
        $(this).change(function(){
            var val = $(this).is(':checked') ? 'bold' : 'normal';
            for(var i = 0; i < partners.length; i++){
                jscss(partners[i], 'font-weight', val);
            }
        });

        var val = $(this).is(':checked') ? 'bold' : 'normal';
        for(var i = 0; i < partners.length; i++){
            jscss(partners[i], 'font-weight', val);
        }
    });

    $('#' + name + '_italic').each(function(){
        $(this).change(function(){
            var val = $(this).is(':checked') ? 'bold' : 'normal';
            for(var i = 0; i < partners.length; i++){
                jscss(partners[i], 'font-style', val);
            }
        });

        var val = $(this).is(':checked') ? 'italic' : 'normal';
        for(var i = 0; i < partners.length; i++){
            jscss(partners[i], 'font-style', val);
        }
    });
}