import debounce from 'lodash/debounce';

import {renderMenubarField} from "../../../common/js/inline-field";
import {adminAjax, hideSuggestion, onKeyupSearchField} from "../../../common/js/search";
import {renderFullscreenMode} from "../../../common/js/fullscreen";
import {optionPrefix, searchField, setSearchFieldElement, generalOptions, optionEl} from "../common";

export  function initSearch(){
    renderMenubarFields();
    renderFullscreenFields();

    setSearchFieldElement();

    searchField.on('input',function(e){
        hideSuggestion(e.target.parentNode);
    });

    searchField.on('input',debounce(function(e){
        dragonflySettings.template = decodeURIComponent(optionEl('suggestion_template').val());
        dragonflySettings.searchOptions = getSearchOptions();
        dragonflySettings.columnCount = optionEl('fullscreen_column').val();

        onKeyupSearchField(
            encodeURIComponent(e.target.value),
            e.target.parentNode,
            dragonflySettings,
            adminAjax
        );
    }, 300));
}

function renderMenubarFields() {
    var menuBarFields = document.querySelectorAll('.dragonfly-inline-field');

    if(menuBarFields){
        for(var i = 0; i < menuBarFields.length; i++){
            renderMenubarField(menuBarFields[i]);
        }
    }
}

function renderFullscreenFields() {
    var fullscrenFields = document.querySelectorAll('.dragonfly-fullscreen');

    if(fullscrenFields){
        for(var i = 0; i < fullscrenFields.length; i++){
            renderFullscreenMode(fullscrenFields[i]);
        }
    }
}

function getSearchOptions(){
    var result = {
        search_by : {},
        searched_terms : [],
        post_types : [],
        suggestion_count : '',
        cat_lvl : '',
        cat_count : '',
    };

    if(generalOptions.search_by_title === true){
        result.search_by.title = true;
    }
    if(generalOptions.search_by_sku === true){
        result.search_by.sku = true;
    }

    result.searched_terms = getSearchedTerms();
    result.post_types = getSeachedPostTypes();
    result.suggestion_count = generalOptions.suggestion_count;
    result.cat_lvl = generalOptions.cat_lvl;
    result.cat_count = generalOptions.cat_count;

    return result;
}

function getSeachedPostTypes(){
    var prefix = optionPrefix + 'search_for_post_type_';
    var result = [];

    $("[id^='" + prefix + "']").each(function(){
        if($(this).is(':checked')){
            result.push($(this).attr('id').replace(prefix, ''));
        }
    });

    return result;
}

function getSearchedTerms(){
    var prefix = optionPrefix + 'search_for_tax_';
    var result = [];

    $("[id^='" + prefix + "']").each(function(){
        if($(this).is(':checked')){
            result.push($(this).attr('id').replace(prefix, ''));
        }
    });

    return result;
}