import first from 'lodash/first';

import {optionEl, searchField, setGeneralOption} from "../common";
import {jscss} from "../../../common/js/jscss";


export function initGeneralOptions(){
    onChangeUpdateOption('search_by_title');
    onChangeUpdateOption('search_by_sku');
    onChangeUpdateOption('suggestion_count');
    onChangeUpdateOption('cat_lvl');
    onChangeUpdateOption('cat_count');
    onChangeUpdateOption('fullscreen_column');


    onChangeMinimalChars();
    onChangeFieldWith();
    onKeyupFieldPlaceholder();
    onChangeFScolumnCount();
    thumbnailRadius();
    fieldBorder();
}

export function onChangeUpdateOption(optionElSelector){
    var el =  optionEl(optionElSelector);
    el.change(function(){
        var value = $(this).is(":checkbox") ?
            !!$(this).is(':checked') : $(this).val();

        setGeneralOption(optionElSelector, value);
    });

    var value = el.is(":checkbox") ? !!el.is(':checked') : el.val();
    setGeneralOption(optionElSelector, value);
}

function onChangeMinimalChars(){
    optionEl('minimal_chars').change(function(){
        dragonflySettings.minLength = $(this).val();
    });
}

function onChangeFieldWith(){
    optionEl('field_width').change(function(){
        $('.dragonfly').not('.dragonfly-menubar').css('max-width', $(this).val());
        $('.dragonfly-menubar .dragonfly-field-wrapper').css('width', $(this).val());
    });
    $('.dragonfly').css('max-width',  optionEl('field_width').val());
}

function onKeyupFieldPlaceholder() {
    optionEl('placeholder').keyup(function(e){
        searchField.attr('placeholder', $(this).val());
    });
    searchField.attr('placeholder', optionEl('placeholder').val());
}

function onChangeFScolumnCount(){
    var element = $('.dragonfly-fullscreen');
    var option = optionEl('fullscreen_column');

    option.change(function () {
        var currentClass = element.attr('class').match(/(\bdragonfly-column-\S+\b)/ig);

        element.removeClass(first(currentClass));
        element.addClass('dragonfly-column-' + $(this).val());
    });

    element.addClass('dragonfly-column-' + option.val())
}

function thumbnailRadius(){
    var element = optionEl('suggestion_thumbnail_radius');
    element.attr('min', 0);
    element.attr('max', 60);
    element.rangeslider({
        polyfill: false,
        onSlide: function(){
            jscss('#dragonfly-suggestion-thubmnail', 'border-radius', element.val() + 'px');
            jscss('.dragonfly-suggestion-thubmnail', 'border-radius', element.val() + 'px');
        }
    });
    jscss('#dragonfly-suggestion-thubmnail', 'border-radius', element.val() + 'px');
    jscss('.dragonfly-suggestion-thubmnail', 'border-radius', element.val() + 'px');
}

function fieldBorder(){
    var element = optionEl('field_radius');
    element.attr('min', 0);
    element.attr('max', 20);
    element.rangeslider({
        polyfill: false,
        onSlide: function(){
            jscss('.dragonfly .dragonfly-field', 'border-radius', element.val() + 'px');
        }
    });
    jscss('.dragonfly .dragonfly-field', 'border-radius', element.val() + 'px');
}