import {components, customizer} from '../common';
import {setSizeOfPlaceholder, togglePlaceholder, updateSetting} from "./helpers";
import {onMouseDownComponent, sortReceiveComponent} from "./components";
import {
    createCol, createRow,
    hideCellBorders,
    hideColumnHelpers,
    hideRowHelpers,
    removeEmptyCells, renderColumnHelpers,
    renderRowHelpers,
    showCellBorders
} from "./grid";

export function initUiSortable(){
    var args = {
        items: ".component",
        connectWith: '.dragonfly-col, .new-col-helper',
        opacity: 0.7,
        appendTo: 'dragonfly-col',
        placeholder: "ui-state-highlight",
        start: function(e, ui){
            showCellBorders();
            setSizeOfPlaceholder(ui.item);
        },
        stop: function(e, ui){
            hideCellBorders();
            hideColumnHelpers();
            hideRowHelpers();
        },
        change: function(e, ui){
            togglePlaceholder(ui);
        },
        update: function(e, ui){
            removeEmptyCells();
            renderRowHelpers();
            renderColumnHelpers();
            createCol(ui);
            createRow(ui);
            updateSetting();
        }
    };

    customizer.sortable(args);
    components.sortable(args);

    sortReceiveComponent();
    onMouseDownComponent(args);
}