import {components, customizer, optionEl} from '../common';

export function loadFromOption(){
    var html = decodeURIComponent(optionEl('suggestion_template').val());
    customizer.html(decodeURIComponent(html));

    components.find('.component').each(function () {
        if($(html).find('#' + $(this).attr('id')).length > 0){
            $(this).remove();
        }
    });
}

export function setSizeOfPlaceholder(item){
    $('.ui-state-highlight').width(item.outerWidth(true))
        .height(item.outerHeight(true));
}

export function togglePlaceholder(ui){
    $('.dragonfly-col').find('.placeholder').show();
    $('.ui-state-highlight').parent()
        .find('.placeholder')
        .hide();
    if(ui.sender && ui.sender.find('.placeholder').length > 0){
        ui.sender.find('.placeholder').show();
    }
}

export function updateSetting(){
    var clone = customizer.clone();
    clone.find('.ui-sortable, .ui-sortable-handle')
        .removeClass('ui-sortable')
        .removeClass('ui-sortable-handle');
    clone.find('.new-row-helper, .new-col-helper')
        .remove();
    clone.find("[style]").removeAttr('style');
    optionEl('suggestion_template').val(encodeURIComponent(clone.html()));
    dragonflySettings.template = clone.html();
}