import {customizer} from '../common';

export function createCol(ui){
    var col =  ui.item.parent();
    if(col.hasClass('new-col-helper')){
        col.removeClass('new-col-helper');
        col.find('.placeholder').remove();
    }else if(ui.sender && ui.sender.children('.placeholder').length > 0){
        ui.sender.addClass('new-col-helper')
            .find('.placeholder')
            .show();
    }
}

export function createRow(ui){
    var row =  ui.item.parents('.new-row-helper');
    if(row.length > 0) {
        row.removeClass('new-row-helper')
            .find('.dragonfly-col')
            .removeClass('new-col-helper')
            .find('.placeholder')
            .remove();
    }else if(ui.sender && ui.sender.children('.placeholder').length > 0){
        ui.sender.addClass('new-col-helper')
            .find('.placeholder')
            .show()
            .parents('.dragonfly-row')
            .first()
            .addClass('new-row-helper');
    }
}

export function removeEmptyCells(){
    customizer.find('.dragonfly-col, .dragonfly-row:not(:last-child)').each(function(){
        var hasChilden = $(this).children().length > 0;
        var hasChildColHelper = $(this).hasClass('dragonfly-row') &&
            $(this).children().length === 1 &&
            $(this).children('.new-col-helper').length > 0;

        if( !hasChilden || hasChildColHelper){
            $(this).remove();
        }
    });
}

export function removeThumbnailCell(state, item){
    var isThubmnail = item && item.attr('id') === 'dragonfly-suggestion-thubmnail';
    var isThumbnailInComponents = isThubmnail && item.parents('#dragonfly-suggestion-components').length > 0;

    if(!isThubmnail || isThumbnailInComponents) {
        customizer.find('.main-row').each(function(){
            if($(this).find('#dragonfly-suggestion-thubmnail').length === 0){
                $(this).find('.has-child-row')
                    .children()
                    .appendTo(customizer);
                $(this).remove();
            }
        });
    }
}

export function showCellBorders(){
    customizer.addClass('show-borders');
}

export function hideCellBorders(){
    customizer.removeClass('show-borders');
}

export function showRowHelpers(){
    $('.new-row-helper').css('display', 'flex');
}

export function hideRowHelpers(){
    $('.new-row-helper').hide();
}

export function showColumnHelpers(){
    $('.new-col-helper').show();
}

export function hideColumnHelpers(){
    $('.new-col-helper').hide();
}

export function renderColumnHelpers(){
    customizer.find('.dragonfly-row').each(function(){
        if($(this).find('.new-col-helper').length === 0 &&
            !$(this).hasClass('new-row-helper')){
            renderColumnHelper($(this));
        }
    });
}

export function renderColumnHelper(appendTo){
    $('<div/>',{
        class: 'dragonfly-col new-col-helper'
    }).append(
        $('<p/>',{
            class: 'placeholder',
            text: 'New Column'
        }).prepend(
            $('<span/>',{
                class: 'dashicons dashicons-plus'
            })
        )
    ).appendTo(appendTo);
}

export function renderRowHelpers(){
    if(customizer.children('.new-row-helper').length === 0){
        renderRowHelper(customizer);
    }

    if(customizer.find('.has-child-row .new-row-helper').length === 0){
        renderRowHelper(customizer.find('.has-child-row').first());
    }
}

export function renderRowHelper(appendTo){
    $('<div/>',{
        class: 'dragonfly-row new-row-helper'
    }).append(
        $('<div/>', {
            class: 'dragonfly-col new-col-helper'
        }).append(
            $('<p/>',{
                class: 'placeholder',
                text: 'New Row'
            }).prepend(
                $('<span/>',{
                    class: 'dashicons dashicons-plus'
                })
            )
        )
    ).appendTo(appendTo);
}

export function renderThumbnailCell(){
    var thumbnailCol = $('<div/>',{
        class: 'dragonfly-col new-col-helper dragonfly-col-2-2'
    }).append(
        $('<p/>',{
            class: 'placeholder',
            text: 'New Column'
        }).prepend(
            $('<span/>',{
                class: 'dashicons dashicons-plus'
            })
        )
    );
    var row =  $('<div/>',{
        class: 'dragonfly-row has-child-row',
    });

    if(customizer.find('.main-row').length > 0){
        if(  customizer.find('.new-col-helper.dragonfly-col-2-2').length === 0){
            customizer.find('.main-row').prepend(thumbnailCol);
        }
        if(customizer.find('.has-child-row').length === 0) {
            customizer.find('.main-row').append(row);
        }
        return;
    }
    var html =  $('<div/>',{
        class: 'dragonfly-row main-row'
    }).append(
        thumbnailCol
    ).append(
        row.append(customizer.children())
    );
    customizer.empty();
    html.appendTo(customizer);
}