import {components, customizer} from '../common';
import {
    hideRowHelpers,
    removeEmptyCells,
    removeThumbnailCell,
    renderColumnHelpers,
    renderRowHelpers,
    renderThumbnailCell, showColumnHelpers, showRowHelpers
} from "./grid";

export function sortReceiveComponent(){
    components.on( "sortreceive", function(e, ui){
        ui.item.attr('style', '');
        removeThumbnailCell('receive', ui.item);
    });
}

export function onMouseDownComponent(args){
    $('#dragonfly-drag-n-drop .component').mousedown(function(){
        if($(this).attr('id') === 'dragonfly-suggestion-thubmnail'){
            hideRowHelpers();
            if($('#dragonfly-suggestion-customizer #dragonfly-suggestion-thubmnail').length === 0){
                removeEmptyCells($(this));
                renderThumbnailCell();
                customizer.find('.dragonfly-col-2-2.new-col-helper').show();
            }
        }else{
            renderRowHelpers();
            renderColumnHelpers();
            showRowHelpers();
            showColumnHelpers();
        }
        $('.new-col-helper').sortable(args);
    }).mouseup(function(){
        if($('.ui-state-highlight').length === 0){
            $('.new-col-helper, .new-row-helper').hide();
            if($(this).attr('id') === 'dragonfly-suggestion-thubmnail' &&
                $(this).parents('.main-row').first().find('.component').length === 0){
                customizer.empty();
            }
        }
    });
}