/**
 * Option prefix
 *
 * @since 1.0.0
 * @type {string}
 */
export var optionPrefix = '_8webit_dragonfly_';

/**
 *  jQuery element of suggestion customizer preview.
 *  inicializes after document ready event
 *
 * @since 1.0.0
 * @type {*|jQuery|HTMLElement}
 */
export var customizer;

/**
 * jQuery element of components for suggestion customizer.
 * inits after document ready event
 *
 * @since 1.0.0
 * @type {*|jQuery|HTMLElement}
 */
export var components;

/**
 * @since 1.0.0
 * @type {boolean|jQuery|HTMLElement}
 */
export var searchField = 'test';

/**
 * @since 1.0.0
 * @type {object}
 */
export var generalOptions = {};

export function setCustomizerElement(){
    customizer = $('#dragonfly-suggestion-customizer');
}

export  function setComponentsElement() {
    components = $('#dragonfly-suggestion-components');
}

/**
 * sets searchField variable
 * @see searchField
 * @since 1.0.0
 */
export function setSearchFieldElement(){
    searchField = $('.dragonfly-field');
}


/**
 * sets generalOptions variable
 * @see generalOptions
 * @since 1.0.0
 */
export function setGeneralOption(property, value){
    generalOptions[property] = value;
}

/**
 * jquery selector for options.
 * option prefix is automatically added.
 *
 * @param {string} selector
 * @returns {jQuery|HTMLElement}
 */
export function optionEl(selector){
    return $('#' + optionPrefix + selector);
}