# Drag Drop Switch - Pause drag and drop for meta boxes on demand

## Description

### Disable drag-drop for meta boxes

This plugin adds a toggle switch under **"Screen Options"** to disable or enable drag-and-drop functionality for meta boxes if the **Classic Editor** plugin is installed and active.

### Why use this plugin?

If you’re using the Classic Editor plugin to manage your WordPress posts and pages, you may have encountered an annoying issue: while scrolling through the post editing page, especially on touch screen devices, the meta boxes on the screen often move unintentionally due to their drag-and-drop functionality. This can disrupt your workflow and create unnecessary frustration.

This plugin solves that problem by disabling the drag-and-drop feature for meta boxes on the post editing page when the Classic Editor is active.

## Installation

### In WordPress Admin Dashboard

1. Navigate to **Plugins > Add New**.
2. Search for **Drag Drop Switch**.
3. Install & activate Drag Drop Switch from your Plugins page.

### Manually

1. Download the plugin from the [WordPress plugins repository](https://wordpress.org/plugins/drag-drop-switch).
2. Unzip the downloaded file and upload the folder to your WordPress site's `/wp-content/plugins/` directory.
3. Activate the Drag Drop Switch plugin through the **Plugins** menu in WordPress.

## Frequently Asked Questions

### Is this plugin free?

Yes, this plugin is completely free to use, with no hidden fees or premium versions. You can download, install, and use it without any cost.

### Does this plugin send any data to third parties?

This plugin does not collect, send, or share any data with third parties, ensuring complete privacy for users.

### How can I report a problem about this plugin?

You can create issues on the [GitHub repository](https://github.com/itsjjfurki/drag-drop-switch/issues).

## Changelog

### 1.0.1 (2025-01-27)

- Compatibility of plugin codebase for publishing in WordPress Plugin Directory is improved

### 1.0.0 (2025-01-26)

- Initial release of the plugin.
- Disables drag-and-drop functionality for meta boxes.

## License

This plugin is licensed under the GPLv3 License. See the [LICENSE](https://www.gnu.org/licenses/gpl.html) file for more details.
