<?php
namespace DPDPA\Services;

if (!defined('ABSPATH')) {
    exit;
}

class Notice
{
    /**
     * Generate the privacy notice content.
     */
    public static function generate_content()
    {
        $settings = get_option('dpdpa_settings', []);
        $org_name = isset($settings['organization_name']) ? $settings['organization_name'] : get_bloginfo('name');
        $dpo_email = isset($settings['dpo_email']) ? $settings['dpo_email'] : get_option('admin_email');

        ob_start();
        ?>
        <div class="dpdpa-privacy-notice">
            <h1>
                <?php
                /* translators: %s: Organization name */
                echo esc_html(sprintf(__('Privacy Notice - %s', 'dpdpa-compliance-india'), $org_name));
                ?>
            </h1>

            <?php if (!empty($settings['notice_intro'])): ?>
                <div class="dpdpa-notice-intro" style="margin-bottom: 20px; font-style: italic; color: #475569;">
                    <?php echo wp_kses_post(wpautop($settings['notice_intro'])); ?>
                </div>
            <?php endif; ?>

            <p><?php esc_html_e('This Privacy Notice is issued in accordance with the Digital Personal Data Protection Act (DPDPA), 2023, India.', 'dpdpa-compliance-india'); ?>
            </p>

            <h2>1.
                <?php esc_html_e('Data Collection', 'dpdpa-compliance-india'); ?>
            </h2>
            <p>
                <?php esc_html_e('We collect personal data which is necessary for the following purposes:', 'dpdpa-compliance-india'); ?>
            </p>
            <ul>
                <li>
                    <?php esc_html_e('Essential operations of the website', 'dpdpa-compliance-india'); ?>
                </li>
                <li>
                    <?php esc_html_e('Communication and grievance redressal', 'dpdpa-compliance-india'); ?>
                </li>
                <?php if (!empty($settings['purposes']['analytics']['enabled'])): ?>
                    <li>
                        <?php esc_html_e('Analytics to improve our services', 'dpdpa-compliance-india'); ?>
                    </li>
                <?php endif; ?>
            </ul>

            <h2>2.
                <?php esc_html_e('Legal Basis', 'dpdpa-compliance-india'); ?>
            </h2>
            <p>
                <?php esc_html_e('We process your data based on your explicit consent, or where processing is necessary for legitimate purposes as defined under the Act.', 'dpdpa-compliance-india'); ?>
            </p>

            <h2>3.
                <?php esc_html_e('Your Rights (Data Principal)', 'dpdpa-compliance-india'); ?>
            </h2>
            <p>
                <?php esc_html_e('As a Data Principal, you have the following rights:', 'dpdpa-compliance-india'); ?>
            </p>
            <ul>
                <li>
                    <?php esc_html_e('Right to Access information about your personal data.', 'dpdpa-compliance-india'); ?>
                </li>
                <li>
                    <?php esc_html_e('Right to Correction and Erasure of your personal data.', 'dpdpa-compliance-india'); ?>
                </li>
                <li>
                    <?php esc_html_e('Right to Grievance Redressal.', 'dpdpa-compliance-india'); ?>
                </li>
                <li>
                    <?php esc_html_e('Right to Withdraw Consent at any time.', 'dpdpa-compliance-india'); ?>
                </li>
            </ul>

            <h2>4.
                <?php esc_html_e('Contact Information', 'dpdpa-compliance-india'); ?>
            </h2>
            <p>
                <?php
                echo wp_kses(
                    /* translators: %s: DPO Email */
                    sprintf(__('For any queries or to exercise your rights, please contact our Data Protection Officer at: %s', 'dpdpa-compliance-india'), '<strong>' . esc_html($dpo_email) . '</strong>'),
                    ['strong' => []]
                );
                ?>
            </p>
        </div>
        <?php
        return ob_get_clean();
    }
}
