<?php
namespace DPDPA\Services;

if (!defined('ABSPATH')) {
    exit;
}

class DSR
{
    /**
     * Create a new DSR request.
     */
    public static function create_request($data)
    {
        global $wpdb;
        $table = $wpdb->prefix . 'dpdpa_requests';

        $token = wp_generate_password(32, false);

        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $inserted = $wpdb->insert($table, [
            'type' => sanitize_text_field($data['type']),
            'name' => sanitize_text_field($data['name']),
            'email' => sanitize_email($data['email']),
            'description' => sanitize_textarea_field($data['description']),
            'metadata' => json_encode([
                'ip' => isset($_SERVER['REMOTE_ADDR']) ? sanitize_text_field(wp_unslash($_SERVER['REMOTE_ADDR'])) : '',
                'user_agent' => isset($_SERVER['HTTP_USER_AGENT']) ? sanitize_text_field(wp_unslash($_SERVER['HTTP_USER_AGENT'])) : '',
                'ref' => isset($data['ref']) ? sanitize_text_field($data['ref']) : '',
            ]),
            'verification_token' => $token,
            'is_verified' => 0,
            'status' => 'pending',
        ]);

        if ($inserted) {
            $request_id = $wpdb->insert_id;
            self::send_verification_email($data['email'], $token, $request_id);
            return $request_id;
        }

        return false;
    }

    /**
     * Send verification email to the user.
     */
    private static function send_verification_email($email, $token, $id)
    {
        $url = add_query_arg([
            'dpdpa_verify' => $token,
            'request_id' => $id,
        ], home_url());

        $subject = __('Verify your Data Subject Request', 'dpdpa-compliance-india');
        $message = sprintf(
            /* translators: %s: Verification URL */
            __("Click the following link to verify your identity and confirm your data request:\n\n%s", 'dpdpa-compliance-india'),
            $url
        );

        wp_mail($email, $subject, $message);
    }
}
