<?php
namespace DPDPA\Frontend;

if (!defined('ABSPATH')) {
	exit;
}

class Shortcodes
{
	public function __construct()
	{
		add_shortcode('dpdpa_privacy_notice', [$this, 'privacy_notice']);
		add_shortcode('dpdpa_request_form', [$this, 'request_form']);
		add_shortcode('dpdpa_consent_status', [$this, 'consent_status']);
	}

	public function privacy_notice($atts)
	{
		return \DPDPA\Services\Notice::generate_content();
	}

	public function request_form($atts)
	{
		$dpdpa_message = '';
		$dpdpa_nonce = isset($_POST['dsr_nonce']) ? sanitize_text_field(wp_unslash($_POST['dsr_nonce'])) : '';
		if (isset($_POST['dpdpa_dsr_submit']) && wp_verify_nonce($dpdpa_nonce, 'dpdpa_dsr_nonce')) {
			$dpdpa_message = $this->handle_form_submission();
		}

		ob_start();
		?>
		<div class="dpdpa-request-form">
			<?php echo $dpdpa_message; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
			<h3><?php esc_html_e('Data Subject Request Form', 'dpdpa-compliance-india'); ?></h3>
			<p><?php esc_html_e('Use this form to exercise your rights under the DPDPA (India).', 'dpdpa-compliance-india'); ?>
			</p>

			<form method="post" action="">
				<?php wp_nonce_field('dpdpa_dsr_nonce', 'dsr_nonce'); ?>
				<div class="dpdpa-form-group">
					<label><?php esc_html_e('Your Name', 'dpdpa-compliance-india'); ?></label>
					<input type="text" name="dpdpa_name" required>
				</div>
				<div class="dpdpa-form-group">
					<label><?php esc_html_e('Your Email', 'dpdpa-compliance-india'); ?></label>
					<input type="email" name="dpdpa_email" required>
				</div>
				<div class="dpdpa-form-group">
					<label><?php esc_html_e('Request Type', 'dpdpa-compliance-india'); ?></label>
					<select name="dpdpa_type">
						<option value="access"><?php esc_html_e('Right to Access', 'dpdpa-compliance-india'); ?></option>
						<option value="correction"><?php esc_html_e('Right to Correction', 'dpdpa-compliance-india'); ?>
						</option>
						<option value="erasure"><?php esc_html_e('Right to Erasure', 'dpdpa-compliance-india'); ?></option>
						<option value="grievance"><?php esc_html_e('Grievance Redressal', 'dpdpa-compliance-india'); ?></option>
					</select>
				</div>
				<div class="dpdpa-form-group">
					<label><?php esc_html_e('Description of Request', 'dpdpa-compliance-india'); ?></label>
					<textarea name="dpdpa_description" required></textarea>
				</div>
				<button type="submit" name="dpdpa_dsr_submit" class="dpdpa-btn dpdpa-btn-primary">
					<?php esc_html_e('Submit Request', 'dpdpa-compliance-india'); ?>
				</button>
			</form>
		</div>
		<style>
			.dpdpa-request-form {
				max-width: 500px;
				padding: 20px;
				border: 1px solid #ddd;
				border-radius: 8px;
			}

			.dpdpa-form-group {
				margin-bottom: 15px;
			}

			.dpdpa-form-group label {
				display: block;
				margin-bottom: 5px;
				font-weight: 600;
			}

			.dpdpa-form-group input,
			.dpdpa-form-group select,
			.dpdpa-form-group textarea {
				width: 100%;
				padding: 8px;
				border: 1px solid #ccc;
				border-radius: 4px;
			}
		</style>
		<?php
		return ob_get_clean();
	}

	private function handle_form_submission()
	{
		$nonce = isset($_POST['dsr_nonce']) ? sanitize_text_field(wp_unslash($_POST['dsr_nonce'])) : '';
		if (!wp_verify_nonce($nonce, 'dpdpa_dsr_nonce')) {
			return '';
		}

		$data = [
			'name' => isset($_POST['dpdpa_name']) ? sanitize_text_field(wp_unslash($_POST['dpdpa_name'])) : '',
			'email' => isset($_POST['dpdpa_email']) ? sanitize_email(wp_unslash($_POST['dpdpa_email'])) : '',
			'type' => isset($_POST['dpdpa_type']) ? sanitize_text_field(wp_unslash($_POST['dpdpa_type'])) : '',
			'description' => isset($_POST['dpdpa_description']) ? sanitize_textarea_field(wp_unslash($_POST['dpdpa_description'])) : '',
		];

		$request_id = \DPDPA\Services\DSR::create_request($data);
		if ($request_id) {
			return '<div class="dpdpa-success" style="padding:15px; background:#dcfce7; color:#166534; border-radius:8px; margin-bottom:20px;">' .
				esc_html__('Your request has been submitted. Please check your email to verify your identity.', 'dpdpa-compliance-india') . ' (Ref: #' . esc_html($request_id) . ')</div>';
		}

		return '';
	}

	public function consent_status($atts)
	{
		return esc_html__('Current consent status functionality coming soon.', 'dpdpa-compliance-india');
	}
}
