<?php
namespace DPDPA\Frontend;

if (!defined('ABSPATH')) {
    exit;
}

class Banner
{
    public function __construct()
    {
        add_action('wp_footer', [$this, 'render_banner']);
        add_action('wp_enqueue_scripts', [$this, 'enqueue_assets']);
    }

    public function enqueue_assets()
    {
        $settings = get_option('dpdpa_settings', []);

        if (empty($settings['enable_banner'])) {
            return;
        }

        wp_enqueue_style('dpdpa-public', DPDPA_URL . 'assets/css/public.css', [], DPDPA_VERSION);
        wp_enqueue_script('dpdpa-public', DPDPA_URL . 'assets/js/public.js', [], DPDPA_VERSION, true);

        wp_localize_script('dpdpa-public', 'dpdpa_banner_vars', [
            'heading' => isset($settings['banner_heading']) ? $settings['banner_heading'] : __('Cookie Consent (DPDPA)', 'dpdpa-compliance-india'),
            'message' => isset($settings['banner_message']) ? $settings['banner_message'] : __('We use cookies and other tracking technologies to improve your browsing experience...', 'dpdpa-compliance-india'),
        ]);

        wp_localize_script('dpdpa-public', 'dpdpa_vars', [
            'ajaxurl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('dpdpa_public_nonce'),
        ]);
    }

    public function render_banner()
    {
        $settings = get_option('dpdpa_settings', []);
        if (empty($settings['enable_banner'])) {
            return;
        }
        // Banner will be created by public.js
    }
}
