<?php
/**
 * Database management class.
 *
 * @package DPDPA_Compliance_India
 */

namespace DPDPA\Data;

if (!defined('ABSPATH')) {
    exit;
}

class Database
{
    /**
     * Create custom tables.
     */
    public static function install()
    {
        global $wpdb;

        $charset_collate = $wpdb->get_charset_collate();

        // Consent Logs Table
        $table_consent_logs = $wpdb->prefix . 'dpdpa_consent_logs';
        $sql_consent_logs = "CREATE TABLE $table_consent_logs (
			id bigint(20) NOT NULL AUTO_INCREMENT,
			timestamp datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
			decision varchar(20) NOT NULL,
			purposes text NOT NULL,
			identifier_hash varchar(64) NOT NULL,
			user_type varchar(20) NOT NULL,
			PRIMARY KEY  (id),
			KEY identifier_hash (identifier_hash)
		) $charset_collate;";

        // DSR Requests Table
        $table_requests = $wpdb->prefix . 'dpdpa_requests';
        $sql_requests = "CREATE TABLE $table_requests (
			id bigint(20) NOT NULL AUTO_INCREMENT,
			created_at datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
			updated_at datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP NOT NULL,
			type varchar(50) NOT NULL,
			status varchar(20) DEFAULT 'pending' NOT NULL,
			name varchar(255) NOT NULL,
			email varchar(255) NOT NULL,
			description text NOT NULL,
			metadata longtext,
			verification_token varchar(64),
			is_verified tinyint(1) DEFAULT 0 NOT NULL,
			PRIMARY KEY  (id),
			KEY email (email),
			KEY status (status)
		) $charset_collate;";

        // DSR Request Logs Table
        $table_request_logs = $wpdb->prefix . 'dpdpa_request_logs';
        $sql_request_logs = "CREATE TABLE $table_request_logs (
			id bigint(20) NOT NULL AUTO_INCREMENT,
			request_id bigint(20) NOT NULL,
			timestamp datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
			action varchar(50) NOT NULL,
			admin_id bigint(20),
			notes text,
			PRIMARY KEY  (id),
			KEY request_id (request_id)
		) $charset_collate;";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta($sql_consent_logs);
        dbDelta($sql_requests);
        dbDelta($sql_request_logs);
    }
}
