<?php
/**
 * Core plugin class.
 *
 * @package DPDPA_Compliance_India
 */

namespace DPDPA;

if (!defined('ABSPATH')) {
    exit;
}

class Core
{
    /**
     * Run the plugin.
     */
    public function run()
    {
        $this->define_hooks();

        if (is_admin()) {
            $this->init_admin();
        } else {
            $this->init_public();
        }
    }

    /**
     * Define global hooks.
     */
    private function define_hooks()
    {
        register_activation_hook(DPDPA_PATH . 'dpdpa-compliance-india.php', [$this, 'activate']);

        // Consent Logging
        add_action('wp_ajax_dpdpa_log_consent', [$this, 'log_consent']);
        add_action('wp_ajax_nopriv_dpdpa_log_consent', [$this, 'log_consent']);
    }

    public function log_consent()
    {
        check_ajax_referer('dpdpa_public_nonce', 'nonce');

        global $wpdb;
        $table = $wpdb->prefix . 'dpdpa_consent_logs';

        $purposes = isset($_POST['purposes']) ? sanitize_text_field(wp_unslash($_POST['purposes'])) : '';
        $decision = isset($_POST['decision']) ? sanitize_text_field(wp_unslash($_POST['decision'])) : 'accept';

        $ip_address = isset($_SERVER['REMOTE_ADDR']) ? sanitize_text_field(wp_unslash($_SERVER['REMOTE_ADDR'])) : '';
        $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? sanitize_text_field(wp_unslash($_SERVER['HTTP_USER_AGENT'])) : '';
        $identifier = md5($ip_address . $user_agent);

        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $wpdb->insert($table, [
            'decision' => $decision,
            'purposes' => $purposes,
            'identifier_hash' => $identifier,
            'user_type' => is_user_logged_in() ? 'logged-in' : 'guest',
        ]);

        wp_send_json_success();
    }

    /**
     * Initialize admin functionality.
     */
    private function init_admin()
    {
        new Admin\Dashboard();
        new Admin\Menu();
        new Admin\Settings();
        new Admin\Requests();
    }

    /**
     * Initialize public functionality.
     */
    private function init_public()
    {
        new Frontend\Banner();
        new Frontend\Shortcodes();
    }

    /**
     * Plugin activation.
     */
    public function activate()
    {
        Data\Database::install();

        // Set default options if not exists
        if (!get_option('dpdpa_settings')) {
            update_option('dpdpa_settings', [
                'onboarding_complete' => false,
                'organization_name' => get_bloginfo('name'),
                'dpo_email' => get_option('admin_email'),
                'purposes' => [
                    'essential' => [
                        'title' => __('Essential', 'dpdpa-compliance-india'),
                        'description' => __('Required for the site to function.', 'dpdpa-compliance-india'),
                        'required' => true,
                    ],
                    'analytics' => [
                        'title' => __('Analytics', 'dpdpa-compliance-india'),
                        'description' => __('Help us understand how you use our site.', 'dpdpa-compliance-india'),
                        'required' => false,
                    ],
                ],
            ]);
        }
    }
}
