<?php
/**
 * Simple autoloader for the plugin.
 *
 * @package DPDPA_Compliance_India
 */

namespace DPDPA;

if (!defined('ABSPATH')) {
    exit;
}

class Autoloader
{
    /**
     * Register the autoloader.
     */
    public static function register()
    {
        spl_autoload_register([__CLASS__, 'autoload']);
    }

    /**
     * Autoload classes.
     *
     * @param string $class Class name.
     */
    public static function autoload($class)
    {
        if (0 !== strpos($class, 'DPDPA\\')) {
            return;
        }

        $relative_class = substr($class, 6);
        $file = DPDPA_PATH . 'includes/' . str_replace('\\', '/', $relative_class) . '.php';

        // Try loading as class-name.php format if direct doesn't exist
        if (!file_exists($file)) {
            $parts = explode('\\', $relative_class);
            $last = array_pop($parts);
            $last = 'class-' . strtolower(str_replace('_', '-', $last)) . '.php';
            $path = implode('/', $parts);
            $file = DPDPA_PATH . 'includes/' . ($path ? $path . '/' : '') . $last;
        }

        if (file_exists($file)) {
            require_once $file;
        }
    }
}
