<?php
/**
 * Settings view.
 *
 * @package DPDPA_Compliance_India
 */

if (!defined('ABSPATH')) {
    exit;
}

$dpdpa_settings = get_option('dpdpa_settings', []);
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$dpdpa_active_tab = isset($_GET['tab']) ? sanitize_key(wp_unslash($_GET['tab'])) : 'organization';
?>

<div class="dpdpa-dashboard">
    <header class="dpdpa-header">
        <div style="display: flex; align-items: center; gap: 16px;">
            <img src="<?php echo esc_url(DPDPA_URL . 'assets/images/icon.svg'); ?>" alt="DPDPA Logo"
                style="width: 48px; height: 48px; border-radius: 8px;">
            <div>
                <h1><?php esc_html_e('DPDPA Settings', 'dpdpa-compliance-india'); ?></h1>
                <p><?php esc_html_e('Configure your site\'s data protection and compliance parameters.', 'dpdpa-compliance-india'); ?>
                </p>
            </div>
        </div>
    </header>

    <nav class="nav-tab-wrapper dpdpa-tabs" style="border-bottom: 1px solid #e2e8f0; margin-bottom: 24px;">
        <a href="?page=dpdpa-settings&tab=organization"
            class="nav-tab <?php echo $dpdpa_active_tab === 'organization' ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Organization', 'dpdpa-compliance-india'); ?>
        </a>
        <a href="?page=dpdpa-settings&tab=consent"
            class="nav-tab <?php echo $dpdpa_active_tab === 'consent' ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Consent & Banner', 'dpdpa-compliance-india'); ?>
        </a>
        <a href="?page=dpdpa-settings&tab=notices"
            class="nav-tab <?php echo $dpdpa_active_tab === 'notices' ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Privacy Notices', 'dpdpa-compliance-india'); ?>
        </a>
        <a href="?page=dpdpa-settings&tab=datamap"
            class="nav-tab <?php echo $dpdpa_active_tab === 'datamap' ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Data Map', 'dpdpa-compliance-india'); ?>
        </a>
        <a href="?page=dpdpa-settings&tab=logs"
            class="nav-tab <?php echo $dpdpa_active_tab === 'logs' ? 'nav-tab-active' : ''; ?>">
            <?php esc_html_e('Audit Logs', 'dpdpa-compliance-india'); ?>
        </a>
    </nav>

    <form method="post" action="options.php" class="dpdpa-settings-form">
        <?php
        settings_fields('dpdpa_settings_group');
        ?>

        <div class="dpdpa-card" style="padding: 30px;">
            <?php if ('organization' === $dpdpa_active_tab): ?>
                <div class="dpdpa-tab-content">
                    <h2><?php esc_html_e('Organization Details', 'dpdpa-compliance-india'); ?></h2>
                    <p><?php esc_html_e('These details are used in your Privacy Notice and Data Subject Request communications.', 'dpdpa-compliance-india'); ?>
                    </p>

                    <div class="dpdpa-form-grid" style="display: grid; gap: 20px; max-width: 600px; margin-top: 24px;">
                        <div class="dpdpa-field">
                            <label
                                style="display:block; margin-bottom:8px; font-weight:600;"><?php esc_html_e('Organization Name', 'dpdpa-compliance-india'); ?></label>
                            <input type="text" name="dpdpa_settings[organization_name]"
                                value="<?php echo esc_attr(isset($dpdpa_settings['organization_name']) ? $dpdpa_settings['organization_name'] : ''); ?>"
                                class="regular-text" style="width:100%">
                        </div>
                        <div class="dpdpa-field">
                            <label
                                style="display:block; margin-bottom:8px; font-weight:600;"><?php esc_html_e('Data Protection Officer (DPO) Email', 'dpdpa-compliance-india'); ?></label>
                            <input type="email" name="dpdpa_settings[dpo_email]"
                                value="<?php echo esc_attr(isset($dpdpa_settings['dpo_email']) ? $dpdpa_settings['dpo_email'] : ''); ?>"
                                class="regular-text" style="width:100%">
                            <p class="description">
                                <?php esc_html_e('Users will contact this email for data requests and grievances.', 'dpdpa-compliance-india'); ?>
                            </p>
                        </div>
                        <div class="dpdpa-field">
                            <label
                                style="display:block; margin-bottom:8px; font-weight:600;"><?php esc_html_e('Grievance Officer Name', 'dpdpa-compliance-india'); ?></label>
                            <input type="text" name="dpdpa_settings[grievance_officer_name]"
                                value="<?php echo esc_attr(isset($dpdpa_settings['grievance_officer_name']) ? $dpdpa_settings['grievance_officer_name'] : ''); ?>"
                                class="regular-text" style="width:100%">
                        </div>
                        <div class="dpdpa-field">
                            <label style="display:block; margin-bottom:8px; font-weight:600;">
                                <?php esc_html_e('Organization Type', 'dpdpa-compliance-india'); ?>
                            </label>
                            <?php $current_role = isset($dpdpa_settings['site_role']) ? $dpdpa_settings['site_role'] : 'blog'; ?>
                            <select name="dpdpa_settings[site_role]" style="width:100%">
                                <option value="blog" <?php selected($current_role, 'blog'); ?>>
                                    <?php esc_html_e('Blog / Information Site', 'dpdpa-compliance-india'); ?>
                                </option>
                                <option value="business" <?php selected($current_role, 'business'); ?>>
                                    <?php esc_html_e('Business Site / Corporate', 'dpdpa-compliance-india'); ?>
                                </option>
                                <option value="ecommerce" <?php selected($current_role, 'ecommerce'); ?>>
                                    <?php esc_html_e('WooCommerce / Online Store', 'dpdpa-compliance-india'); ?>
                                </option>
                                <option value="membership" <?php selected($current_role, 'membership'); ?>>
                                    <?php esc_html_e('Membership / Community Platform', 'dpdpa-compliance-india'); ?>
                                </option>
                            </select>
                            <p class="description">
                                <?php esc_html_e('This helps determine the default requirements for your privacy compliance.', 'dpdpa-compliance-india'); ?>
                            </p>
                        </div>
                    </div>
                </div>

            <?php elseif ('consent' === $dpdpa_active_tab): ?>
                <div class="dpdpa-tab-content">
                    <h2><?php esc_html_e('Consent Banner Configuration', 'dpdpa-compliance-india'); ?></h2>
                    <p><?php esc_html_e('Customize how the consent banner appears and behaves on your site.', 'dpdpa-compliance-india'); ?>
                    </p>

                    <div class="dpdpa-form-grid" style="display: grid; gap: 20px; max-width: 600px; margin-top: 24px;">
                        <div class="dpdpa-field">
                            <label style="display:block; margin-bottom:8px; font-weight:600;">
                                <input type="checkbox" name="dpdpa_settings[enable_banner]" value="1" <?php checked(isset($dpdpa_settings['enable_banner']) && $dpdpa_settings['enable_banner'], 1); ?>>
                                <?php esc_html_e('Enable Consent Banner', 'dpdpa-compliance-india'); ?>
                            </label>
                        </div>
                        <div class="dpdpa-field">
                            <label
                                style="display:block; margin-bottom:8px; font-weight:600;"><?php esc_html_e('Banner Heading', 'dpdpa-compliance-india'); ?></label>
                            <input type="text" name="dpdpa_settings[banner_heading]"
                                value="<?php echo esc_attr(isset($dpdpa_settings['banner_heading']) ? $dpdpa_settings['banner_heading'] : __('Cookie Consent (DPDPA)', 'dpdpa-compliance-india')); ?>"
                                style="width:100%">
                        </div>
                        <div class="dpdpa-field">
                            <label
                                style="display:block; margin-bottom:8px; font-weight:600;"><?php esc_html_e('Banner Message', 'dpdpa-compliance-india'); ?></label>
                            <textarea name="dpdpa_settings[banner_message]"
                                style="width:100%; height: 100px;"><?php echo esc_textarea(isset($dpdpa_settings['banner_message']) ? $dpdpa_settings['banner_message'] : __('We use cookies and other tracking technologies to improve your browsing experience on our website...', 'dpdpa-compliance-india')); ?></textarea>
                        </div>

                        <div class="dpdpa-field"
                            style="border-top: 1px solid #e2e8f0; padding-top: 20px; margin-top: 10px;">
                            <label style="display:block; margin-bottom:12px; font-weight:600;">
                                <?php esc_html_e('Enabled Consent Purposes', 'dpdpa-compliance-india'); ?>
                            </label>
                            <p class="description" style="margin-bottom: 15px;">
                                <?php esc_html_e('Select which data processing categories you want to offer to users. Essential is always required.', 'dpdpa-compliance-india'); ?>
                            </p>

                            <?php
                            $enabled_purposes = isset($dpdpa_settings['enabled_purposes']) ? $dpdpa_settings['enabled_purposes'] : ['essential', 'analytics', 'marketing'];
                            ?>

                            <div style="display: grid; gap: 10px;">
                                <label style="display: flex; align-items: center; gap: 8px;">
                                    <input type="checkbox" checked disabled>
                                    <span><?php esc_html_e('Essential (Required)', 'dpdpa-compliance-india'); ?></span>
                                    <input type="hidden" name="dpdpa_settings[enabled_purposes][]" value="essential">
                                </label>

                                <label style="display: flex; align-items: center; gap: 8px;">
                                    <input type="checkbox" name="dpdpa_settings[enabled_purposes][]" value="analytics" <?php checked(in_array('analytics', $enabled_purposes)); ?>>
                                    <span><?php esc_html_e('Analytics & Statistics', 'dpdpa-compliance-india'); ?></span>
                                </label>

                                <label style="display: flex; align-items: center; gap: 8px;">
                                    <input type="checkbox" name="dpdpa_settings[enabled_purposes][]" value="marketing" <?php checked(in_array('marketing', $enabled_purposes)); ?>>
                                    <span><?php esc_html_e('Marketing & Advertising', 'dpdpa-compliance-india'); ?></span>
                                </label>

                                <label style="display: flex; align-items: center; gap: 8px;">
                                    <input type="checkbox" name="dpdpa_settings[enabled_purposes][]" value="personalization"
                                        <?php checked(in_array('personalization', $enabled_purposes)); ?>>
                                    <span><?php esc_html_e('Personalization', 'dpdpa-compliance-india'); ?></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

            <?php elseif ('notices' === $dpdpa_active_tab): ?>
                <div class="dpdpa-tab-content">
                    <h2><?php esc_html_e('Privacy Notice Templates', 'dpdpa-compliance-india'); ?></h2>
                    <p><?php esc_html_e('Manage the legal text used in your auto-generated privacy notice.', 'dpdpa-compliance-india'); ?>
                    </p>

                    <div
                        style="background: #f0fdf4; padding: 20px; border-radius: 12px; border: 1px solid #bbfcce; margin-top: 20px;">
                        <p><strong><?php esc_html_e('Note:', 'dpdpa-compliance-india'); ?></strong>
                            <?php esc_html_e('You can use the shortcode [dpdpa_privacy_notice] to display this text on any page.', 'dpdpa-compliance-india'); ?>
                        </p>
                    </div>

                    <div class="dpdpa-form-grid" style="display: grid; gap: 20px; max-width: 800px; margin-top: 24px;">
                        <div class="dpdpa-field">
                            <label
                                style="display:block; margin-bottom:8px; font-weight:600;"><?php esc_html_e('Custom Introduction', 'dpdpa-compliance-india'); ?></label>
                            <textarea name="dpdpa_settings[notice_intro]"
                                style="width:100%; height: 100px;"><?php echo esc_textarea(isset($dpdpa_settings['notice_intro']) ? $dpdpa_settings['notice_intro'] : ''); ?></textarea>
                        </div>
                    </div>
                </div>

            <?php elseif ('datamap' === $dpdpa_active_tab): ?>
                <div class="dpdpa-tab-content">
                    <h2><?php esc_html_e('Data Map', 'dpdpa-compliance-india'); ?></h2>
                    <p><?php esc_html_e('A visual breakdown of what data your site collects and why.', 'dpdpa-compliance-india'); ?>
                    </p>

                    <div class="dpdpa-metric-card" style="margin-top: 24px; border-style: dashed;">
                        <p style="text-align: center; color: var(--dpdpa-text-muted);">
                            <?php esc_html_e('The Data Map scans your site for known data collection points (WooCommerce, Gravity Forms, etc.). Feature coming in next update.', 'dpdpa-compliance-india'); ?>
                        </p>
                    </div>

                <?php elseif ('logs' === $dpdpa_active_tab): ?>
                    <div class="dpdpa-tab-content">
                        <h2><?php esc_html_e('Audit Logs', 'dpdpa-compliance-india'); ?></h2>
                        <p><?php esc_html_e('Recent consent and processing activities logs.', 'dpdpa-compliance-india'); ?>
                        </p>

                        <div style="margin-top: 24px;">
                            <?php
                            global $wpdb;
                            $dpdpa_logs_table = $wpdb->prefix . 'dpdpa_consent_logs';
                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
                            $dpdpa_logs = $wpdb->get_results("SELECT * FROM {$dpdpa_logs_table} ORDER BY timestamp DESC LIMIT 10");
                            ?>
                            <table class="wp-list-table widefat fixed striped">
                                <thead>
                                    <tr>
                                        <th><?php esc_html_e('Time', 'dpdpa-compliance-india'); ?></th>
                                        <th><?php esc_html_e('Decision', 'dpdpa-compliance-india'); ?></th>
                                        <th><?php esc_html_e('Purposes', 'dpdpa-compliance-india'); ?></th>
                                        <th><?php esc_html_e('User Type', 'dpdpa-compliance-india'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (empty($dpdpa_logs)): ?>
                                        <tr>
                                            <td colspan="4"><?php esc_html_e('No logs found.', 'dpdpa-compliance-india'); ?>
                                            </td>
                                        </tr>
                                    <?php else: ?>
                                        <?php foreach ($dpdpa_logs as $dpdpa_log): ?>
                                            <tr>
                                                <td><?php echo esc_html($dpdpa_log->timestamp); ?></td>
                                                <td>
                                                    <span class="dpdpa-status-pill"
                                                        style="
                                                    background: <?php echo $dpdpa_log->decision === 'accept' ? '#dcfce7' : ($dpdpa_log->decision === 'reject' ? '#fee2e2' : '#fef9c3'); ?>; 
                                                    color: <?php echo $dpdpa_log->decision === 'accept' ? '#166534' : ($dpdpa_log->decision === 'reject' ? '#991b1b' : '#854d0e'); ?>;">
                                                        <?php echo esc_html(ucfirst($dpdpa_log->decision)); ?>
                                                    </span>
                                                </td>
                                                <td><?php echo esc_html($dpdpa_log->purposes); ?></td>
                                                <td><?php echo esc_html($dpdpa_log->user_type); ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if ($dpdpa_active_tab !== 'logs' && $dpdpa_active_tab !== 'datamap'): ?>
                    <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid var(--dpdpa-border);">
                        <?php submit_button(esc_html__('Save Compliance Settings', 'dpdpa-compliance-india'), 'primary', 'submit', false, ['class' => 'dpdpa-btn dpdpa-btn-primary']); ?>
                    </div>
                <?php endif; ?>
            </div>
    </form>
</div>