<?php
/**
 * DSR Requests view.
 *
 * @package DPDPA_Compliance_India
 */

if (!defined('ABSPATH')) {
	exit;
}

global $wpdb;
$dpdpa_requests_table = $wpdb->prefix . 'dpdpa_requests';
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
$dpdpa_all_requests = $wpdb->get_results("SELECT * FROM {$dpdpa_requests_table} ORDER BY created_at DESC");

// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$dpdpa_current_action = isset($_GET['action']) ? sanitize_text_field(wp_unslash($_GET['action'])) : '';
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$dpdpa_current_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
?>

<div class="dpdpa-dashboard">
	<header class="dpdpa-header">
		<div style="display: flex; align-items: center; gap: 16px;">
			<img src="<?php echo esc_url(DPDPA_URL . 'assets/images/icon.svg'); ?>" alt="DPDPA Logo"
				style="width: 48px; height: 48px; border-radius: 8px;">
			<div>
				<h1><?php esc_html_e('Data Subject Requests (DSR)', 'dpdpa-compliance-india'); ?></h1>
				<p><?php esc_html_e('Manage requests from Data Principals.', 'dpdpa-compliance-india'); ?></p>
			</div>
		</div>
	</header>

	<?php if ('view' === $dpdpa_current_action && $dpdpa_current_id):
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
		$dpdpa_request = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$dpdpa_requests_table} WHERE id = %d", $dpdpa_current_id));
		if ($dpdpa_request):
			$dpdpa_metadata = json_decode($dpdpa_request->metadata, true);
			?>
			<div class="dpdpa-card" style="padding: 30px;">
				<?php
				// phpcs:ignore WordPress.Security.NonceVerification.Recommended
				if (isset($_GET['updated'])): ?>
					<div class="notice notice-success is-dismissible" style="margin: 0 0 20px 0;">
						<p><?php esc_html_e('Request status updated successfully.', 'dpdpa-compliance-india'); ?></p>
					</div>
				<?php endif; ?>

				<a href="?page=dpdpa-requests" class="button" style="margin-bottom: 20px;">&larr;
					<?php esc_html_e('Back to List', 'dpdpa-compliance-india'); ?></a>

				<div style="display: grid; grid-template-columns: 2fr 1fr; gap: 30px;">
					<div>
						<div style="display: flex; align-items: center; gap: 15px; margin-bottom: 20px;">
							<h2 style="margin: 0;">
								<?php
								/* translators: %d: Request ID */
								echo esc_html(sprintf(__('Request Details #%d', 'dpdpa-compliance-india'), $dpdpa_current_id));
								?>
							</h2>
							<span class="dpdpa-status-pill"
								style="background: <?php echo $dpdpa_request->status === 'completed' ? '#dcfce7' : ($dpdpa_request->status === 'rejected' ? '#fee2e2' : '#fef9c3'); ?>; color: <?php echo $dpdpa_request->status === 'completed' ? '#166534' : ($dpdpa_request->status === 'rejected' ? '#991b1b' : '#854d0e'); ?>;">
								<?php echo esc_html(ucfirst($dpdpa_request->status)); ?>
							</span>
						</div>

						<div style="background: #f8fafc; padding: 20px; border-radius: 8px; border: 1px solid #e2e8f0;">
							<h4 style="margin-top: 0; color: #64748b;">
								<?php esc_html_e('Description', 'dpdpa-compliance-india'); ?>
							</h4>
							<p style="white-space: pre-wrap; font-size: 15px; line-height: 1.6;">
								<?php echo esc_html($dpdpa_request->description); ?>
							</p>
						</div>

						<?php if ($dpdpa_request->status === 'pending'): ?>
							<div style="margin-top: 30px;">
								<form method="post" action="" style="display: flex; gap: 10px;">
									<?php wp_nonce_field('dpdpa_update_request_' . $dpdpa_current_id); ?>
									<input type="hidden" name="dpdpa_request_id" value="<?php echo esc_attr($dpdpa_current_id); ?>">

									<button type="submit" name="dpdpa_action" value="complete" class="button button-primary">
										<?php esc_html_e('Mark as Completed', 'dpdpa-compliance-india'); ?>
									</button>
									<button type="submit" name="dpdpa_action" value="reject" class="button">
										<?php esc_html_e('Reject Request', 'dpdpa-compliance-india'); ?>
									</button>
								</form>
							</div>
						<?php endif; ?>
					</div>

					<div>
						<div class="dpdpa-card" style="background: #f1f5f9; padding: 20px; border: none;">
							<h4 style="margin-top: 0;"><?php esc_html_e('Principal Information', 'dpdpa-compliance-india'); ?>
							</h4>
							<p><strong><?php esc_html_e('Name:', 'dpdpa-compliance-india'); ?></strong>
								<?php echo esc_html($dpdpa_request->name); ?></p>
							<p><strong><?php esc_html_e('Email:', 'dpdpa-compliance-india'); ?></strong>
								<?php echo esc_html($dpdpa_request->email); ?></p>
							<p><strong><?php esc_html_e('Type:', 'dpdpa-compliance-india'); ?></strong>
								<?php echo esc_html(ucfirst($dpdpa_request->type)); ?></p>
							<hr>
							<p><strong><?php esc_html_e('Verified:', 'dpdpa-compliance-india'); ?></strong>
								<?php echo esc_html($dpdpa_request->is_verified ? '✅ Yes' : '❌ No'); ?></p>
							<p><strong><?php esc_html_e('IP Address:', 'dpdpa-compliance-india'); ?></strong>
								<?php echo esc_html($dpdpa_metadata['ip'] ?? 'N/A'); ?></p>
							<p><small
									style="color:#94a3b8;"><?php echo esc_html($dpdpa_metadata['user_agent'] ?? ''); ?></small>
							</p>
						</div>
					</div>
				</div>
			</div>
		<?php else: ?>
			<div class="notice notice-error">
				<p><?php esc_html_e('Request not found.', 'dpdpa-compliance-india'); ?></p>
			</div>
		<?php endif; ?>

	<?php else: ?>
		<div class="dpdpa-card" style="padding: 20px;">
			<table class="wp-list-table widefat fixed striped">
				<thead>
					<tr>
						<th><?php esc_html_e('ID', 'dpdpa-compliance-india'); ?></th>
						<th><?php esc_html_e('Type', 'dpdpa-compliance-india'); ?></th>
						<th><?php esc_html_e('Principal', 'dpdpa-compliance-india'); ?></th>
						<th><?php esc_html_e('Status', 'dpdpa-compliance-india'); ?></th>
						<th><?php esc_html_e('Submitted', 'dpdpa-compliance-india'); ?></th>
						<th><?php esc_html_e('Actions', 'dpdpa-compliance-india'); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php if (empty($dpdpa_all_requests)): ?>
						<tr>
							<td colspan="6" style="text-align: center; padding: 40px;">
								<div style="font-size: 40px; margin-bottom: 10px;">⚖️</div>
								<h3><?php esc_html_e('No requests yet', 'dpdpa-compliance-india'); ?></h3>
								<p><?php esc_html_e('Add the [dpdpa_request_form] shortcode to your site to start receiving requests.', 'dpdpa-compliance-india'); ?>
								</p>
							</td>
						</tr>
					<?php else: ?>
						<?php foreach ($dpdpa_all_requests as $dpdpa_request): ?>
							<tr>
								<td>#<?php echo esc_html($dpdpa_request->id); ?></td>
								<td><strong><?php echo esc_html(ucfirst($dpdpa_request->type)); ?></strong></td>
								<td>
									<?php echo esc_html($dpdpa_request->name); ?><br>
									<small><?php echo esc_html($dpdpa_request->email); ?></small>
								</td>
								<td>
									<div style="display: flex; flex-direction: column; gap: 5px;">
										<span class="dpdpa-status-pill"
											style="background: <?php echo $dpdpa_request->status === 'completed' ? '#dcfce7' : ($dpdpa_request->status === 'rejected' ? '#fee2e2' : '#fef9c3'); ?>; color: <?php echo $dpdpa_request->status === 'completed' ? '#166534' : ($dpdpa_request->status === 'rejected' ? '#991b1b' : '#854d0e'); ?>;">
											<?php echo esc_html(ucfirst($dpdpa_request->status)); ?>
										</span>
										<small style="color: <?php echo $dpdpa_request->is_verified ? '#16a34a' : '#dc2626'; ?>;">
											<?php echo esc_html($dpdpa_request->is_verified ? '✓ Verified' : '⚠ Unverified'); ?>
										</small>
									</div>
								</td>
								<td><?php echo esc_html($dpdpa_request->created_at); ?></td>
								<td>
									<a href="?page=dpdpa-requests&action=view&id=<?php echo esc_attr($dpdpa_request->id); ?>"
										class="button"><?php esc_html_e('View', 'dpdpa-compliance-india'); ?></a>
								</td>
							</tr>
						<?php endforeach; ?>
					<?php endif; ?>
				</tbody>
			</table>
		</div>
	<?php endif; ?>
</div>