<?php
/**
 * Dashboard view.
 *
 * @package DPDPA_Compliance_India
 */

if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;

$dpdpa_dashboard_settings = get_option('dpdpa_settings', []);
$dpdpa_onboarding_complete = !empty($dpdpa_dashboard_settings['onboarding_complete']);

// --- Fetch Real Metrics ---

// 1. Total Consents (30 days)
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
$dpdpa_consents_30d = $wpdb->get_var(
    $wpdb->prepare(
        "SELECT COUNT(*) FROM {$wpdb->prefix}dpdpa_consent_logs WHERE timestamp >= %s",
        gmdate('Y-m-d H:i:s', strtotime('-30 days'))
    )
);

// 2. Pending DSR Requests
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
$dpdpa_pending_requests = $wpdb->get_var(
    "SELECT COUNT(*) FROM {$wpdb->prefix}dpdpa_requests WHERE status = 'pending'"
);

// 3. Last Policy Update - Search for page containing the shortcode
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, PluginCheck.Security.DirectDB.UnescapedDBParameter
$dpdpa_policy_page = $wpdb->get_row(
    $wpdb->prepare(
        "SELECT ID, post_modified FROM {$wpdb->posts} WHERE post_content LIKE %s AND post_status = 'publish' AND post_type = 'page' LIMIT 1",
        '%' . $wpdb->esc_like('[dpdpa_privacy_notice]') . '%'
    )
);
$dpdpa_last_update = $dpdpa_policy_page ? date_i18n(get_option('date_format'), strtotime($dpdpa_policy_page->post_modified)) : __('None', 'dpdpa-compliance-india');

// --- Dynamic Badge Logic ---
$dpdpa_banner_active = !empty($dpdpa_dashboard_settings['enable_banner']);
?>

<div class="dpdpa-dashboard">
    <header class="dpdpa-header">
        <div style="display: flex; align-items: center; gap: 16px;">
            <img src="<?php echo esc_url(DPDPA_URL . 'assets/images/icon.svg'); ?>" alt="DPDPA Logo"
                style="width: 48px; height: 48px; border-radius: 8px;">
            <div>
                <h1><?php esc_html_e('DPDPA Privacy Dashboard', 'dpdpa-compliance-india'); ?></h1>
                <p><?php esc_html_e('Manage your compliance with India\'s Digital Personal Data Protection Act.', 'dpdpa-compliance-india'); ?>
                </p>
            </div>
        </div>
        <div class="dpdpa-status-pill"
            style="background: <?php echo $dpdpa_banner_active ? '#dcfce7' : '#fef9c3'; ?>; color: <?php echo $dpdpa_banner_active ? '#166534' : '#854d0e'; ?>;">
            <?php echo esc_html($dpdpa_banner_active ? __('Compliance Status: Active', 'dpdpa-compliance-india') : __('Compliance Status: Setup Needed', 'dpdpa-compliance-india')); ?>
        </div>
    </header>

    <div class="dpdpa-metrics">
        <div class="dpdpa-metric-card">
            <h3><?php esc_html_e('Total Consents (30d)', 'dpdpa-compliance-india'); ?></h3>
            <p class="value"><?php echo esc_html(number_format_i18n($dpdpa_consents_30d)); ?></p>
        </div>
        <div class="dpdpa-metric-card">
            <h3><?php esc_html_e('Pending Requests', 'dpdpa-compliance-india'); ?></h3>
            <p class="value"><?php echo esc_html(number_format_i18n($dpdpa_pending_requests)); ?></p>
        </div>
        <div class="dpdpa-metric-card">
            <h3><?php esc_html_e('Last Policy Update', 'dpdpa-compliance-india'); ?></h3>
            <p class="value"><?php echo esc_html($dpdpa_last_update); ?></p>
        </div>
    </div>

    <div class="dpdpa-grid">
        <!-- Consent & Banner -->
        <div class="dpdpa-card">
            <div class="dpdpa-card-content">
                <div class="dpdpa-card-icon">🛡️</div>
                <h2><?php esc_html_e('Consent & Banner', 'dpdpa-compliance-india'); ?></h2>
                <p><?php esc_html_e('Manage your cookie consent banner and granular purposes according to DPDPA guidelines.', 'dpdpa-compliance-india'); ?>
                </p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=dpdpa-settings&tab=consent')); ?>"
                    class="dpdpa-btn dpdpa-btn-primary">
                    <?php esc_html_e('Configure Banner', 'dpdpa-compliance-india'); ?>
                </a>
            </div>
            <div class="dpdpa-card-footer">
                <span class="dpdpa-status-pill"
                    style="background: <?php echo $dpdpa_banner_active ? '#dcfce7' : '#fee2e2'; ?>; color: <?php echo $dpdpa_banner_active ? '#166534' : '#991b1b'; ?>;">
                    <?php echo esc_html($dpdpa_banner_active ? __('Active', 'dpdpa-compliance-india') : __('Action Needed', 'dpdpa-compliance-india')); ?>
                </span>
            </div>
        </div>

        <!-- Privacy & Notices -->
        <div class="dpdpa-card">
            <div class="dpdpa-card-content">
                <div class="dpdpa-card-icon">📄</div>
                <h2><?php esc_html_e('Privacy & Notices', 'dpdpa-compliance-india'); ?></h2>
                <p><?php esc_html_e('Generate and maintain your DPDPA-compliant Privacy Notice and legal disclosures.', 'dpdpa-compliance-india'); ?>
                </p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=dpdpa-settings&tab=notices')); ?>"
                    class="dpdpa-btn dpdpa-btn-primary">
                    <?php esc_html_e('Manage Notices', 'dpdpa-compliance-india'); ?>
                </a>
            </div>
            <div class="dpdpa-card-footer">
                <span class="dpdpa-status-pill"
                    style="background: <?php echo $dpdpa_policy_page ? '#dcfce7' : '#fee2e2'; ?>; color: <?php echo $dpdpa_policy_page ? '#166534' : '#991b1b'; ?>;">
                    <?php echo esc_html($dpdpa_policy_page ? __('Active', 'dpdpa-compliance-india') : __('Page Missing', 'dpdpa-compliance-india')); ?>
                </span>
            </div>
        </div>

        <!-- Data Subject Rights -->
        <div class="dpdpa-card">
            <div class="dpdpa-card-content">
                <div class="dpdpa-card-icon">⚖️</div>
                <h2><?php esc_html_e('Data Subject Rights', 'dpdpa-compliance-india'); ?></h2>
                <p><?php esc_html_e('Handle data access, correction, and erasure requests from your users/data principals.', 'dpdpa-compliance-india'); ?>
                </p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=dpdpa-requests')); ?>"
                    class="dpdpa-btn dpdpa-btn-primary">
                    <?php esc_html_e('View Requests', 'dpdpa-compliance-india'); ?>
                </a>
            </div>
            <div class="dpdpa-card-footer">
                <span class="dpdpa-status-pill"
                    style="background: <?php echo $dpdpa_pending_requests > 0 ? '#fee2e2' : '#dcfce7'; ?>; color: <?php echo $dpdpa_pending_requests > 0 ? '#991b1b' : '#166534'; ?>;">
                    <?php
                    /* translators: %d: number of pending requests */
                    echo esc_html($dpdpa_pending_requests > 0 ? sprintf(_n('%d Pending', '%d Pending', $dpdpa_pending_requests, 'dpdpa-compliance-india'), $dpdpa_pending_requests) : __('No Pending', 'dpdpa-compliance-india'));
                    ?>
                </span>
            </div>
        </div>

        <!-- Data Map & Retention -->
        <div class="dpdpa-card">
            <div class="dpdpa-card-content">
                <div class="dpdpa-card-icon">🗺️</div>
                <h2><?php esc_html_e('Data Map & Retention', 'dpdpa-compliance-india'); ?></h2>
                <p><?php esc_html_e('Map where your data is stored and set automatic retention policies.', 'dpdpa-compliance-india'); ?>
                </p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=dpdpa-settings&tab=datamap')); ?>"
                    class="dpdpa-btn dpdpa-btn-primary">
                    <?php esc_html_e('Review Data Map', 'dpdpa-compliance-india'); ?>
                </a>
            </div>
            <div class="dpdpa-card-footer">
                <span class="dpdpa-status-pill">
                    <?php esc_html_e('Draft', 'dpdpa-compliance-india'); ?>
                </span>
            </div>
        </div>

        <!-- Audit & Logs -->
        <div class="dpdpa-card">
            <div class="dpdpa-card-content">
                <div class="dpdpa-card-icon">📋</div>
                <h2><?php esc_html_e('Audit & Logs', 'dpdpa-compliance-india'); ?></h2>
                <p><?php esc_html_e('View historical consent decisions and request processing logs for auditing.', 'dpdpa-compliance-india'); ?>
                </p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=dpdpa-settings&tab=logs')); ?>"
                    class="dpdpa-btn dpdpa-btn-primary">
                    <?php esc_html_e('View Logs', 'dpdpa-compliance-india'); ?>
                </a>
            </div>
            <div class="dpdpa-card-footer">
                <span class="dpdpa-status-pill">
                    <?php esc_html_e('Logging Active', 'dpdpa-compliance-india'); ?>
                </span>
            </div>
        </div>
    </div>
</div>

<?php if (!$dpdpa_onboarding_complete): ?>
    <div class="dpdpa-wizard-overlay" id="dpdpa-wizard">
        <div class="dpdpa-wizard">
            <div class="dpdpa-wizard-header">
                <h2>
                    <?php esc_html_e('Welcome to DPDPA Compliance', 'dpdpa-compliance-india'); ?>
                </h2>
                <div class="dpdpa-wizard-steps">
                    <div class="dpdpa-step-dot active"></div>
                    <div class="dpdpa-step-dot"></div>
                    <div class="dpdpa-step-dot"></div>
                    <div class="dpdpa-step-dot"></div>
                </div>
            </div>
            <div class="dpdpa-wizard-body" id="dpdpa-wizard-content">
                <!-- Step 1 Content -->
                <div class="dpdpa-step" data-step="1">
                    <h3>
                        <?php esc_html_e('Identify your role', 'dpdpa-compliance-india'); ?>
                    </h3>
                    <p>
                        <?php esc_html_e('This helps us tune the compliance requirements for your site type.', 'dpdpa-compliance-india'); ?>
                    </p>
                    <div style="display: grid; gap: 10px; margin-top: 20px;">
                        <label><input type="radio" name="site_role" value="blog" checked>
                            <?php esc_html_e('Blog / Information Site', 'dpdpa-compliance-india'); ?>
                        </label>
                        <label><input type="radio" name="site_role" value="business">
                            <?php esc_html_e('Business Site', 'dpdpa-compliance-india'); ?>
                        </label>
                        <label><input type="radio" name="site_role" value="ecommerce">
                            <?php esc_html_e('WooCommerce / Store', 'dpdpa-compliance-india'); ?>
                        </label>
                        <label><input type="radio" name="site_role" value="membership">
                            <?php esc_html_e('Membership / Community', 'dpdpa-compliance-india'); ?>
                        </label>
                    </div>
                </div>
            </div>
            <div class="dpdpa-wizard-footer">
                <button type="button" class="dpdpa-btn" id="dpdpa-skip-wizard">
                    <?php esc_html_e('Skip for now', 'dpdpa-compliance-india'); ?>
                </button>
                <button type="button" class="dpdpa-btn dpdpa-btn-primary" id="dpdpa-next-step">
                    <?php esc_html_e('Next: Org Details', 'dpdpa-compliance-india'); ?>
                </button>
            </div>
        </div>
    </div>
<?php endif; ?>