<?php
namespace DPDPA\Admin;

if (!defined('ABSPATH')) {
    exit;
}

class Settings
{
    public function __construct()
    {
        add_action('admin_init', [$this, 'register_admin_settings']);
    }

    /**
     * Register settings using the Settings API.
     */
    public function register_admin_settings()
    {
        register_setting('dpdpa_settings_group', 'dpdpa_settings', [
            'type' => 'array',
            'sanitize_callback' => [$this, 'sanitize_settings'],
            'default' => [],
        ]);
    }

    /**
     * Sanitize settings input.
     */
    public function sanitize_settings($input)
    {
        $output = get_option('dpdpa_settings', []);

        if (isset($input['onboarding_complete'])) {
            $output['onboarding_complete'] = (bool) $input['onboarding_complete'];
        }

        if (isset($input['organization_name'])) {
            $output['organization_name'] = sanitize_text_field($input['organization_name']);
        }
        if (isset($input['dpo_email'])) {
            $output['dpo_email'] = sanitize_email($input['dpo_email']);
        }
        if (isset($input['grievance_officer_name'])) {
            $output['grievance_officer_name'] = sanitize_text_field($input['grievance_officer_name']);
        }
        if (isset($input['site_role'])) {
            $output['site_role'] = sanitize_text_field($input['site_role']);
        }
        // Only update banner state if we are likely on the consent tab
        if (isset($input['banner_heading']) || isset($input['banner_message']) || isset($input['enable_banner'])) {
            $output['enable_banner'] = isset($input['enable_banner']) ? (bool) $input['enable_banner'] : false;
        }

        if (isset($input['banner_heading'])) {
            $output['banner_heading'] = sanitize_text_field($input['banner_heading']);
        }
        if (isset($input['banner_message'])) {
            $output['banner_message'] = sanitize_textarea_field($input['banner_message']);
        }
        if (isset($input['notice_intro'])) {
            $output['notice_intro'] = sanitize_textarea_field($input['notice_intro']);
        }

        if (isset($input['enabled_purposes']) && is_array($input['enabled_purposes'])) {
            $allowed = ['essential', 'analytics', 'marketing', 'personalization'];
            $output['enabled_purposes'] = array_intersect(array_map('sanitize_text_field', $input['enabled_purposes']), $allowed);
            if (!in_array('essential', $output['enabled_purposes'])) {
                $output['enabled_purposes'][] = 'essential';
            }
        }

        return $output;
    }
}
