<?php
namespace DPDPA\Admin;

if (!defined('ABSPATH')) {
    exit;
}

class Requests
{
    public function __construct()
    {
        add_action('admin_init', [$this, 'handle_request_updates']);
    }

    /**
     * Handle DSR request status updates (Complete/Reject).
     */
    public function handle_request_updates()
    {
        if (!isset($_POST['dpdpa_action']) || !isset($_POST['dpdpa_request_id'])) {
            return;
        }

        $id = intval($_POST['dpdpa_request_id']);
        $nonce = isset($_POST['_wpnonce']) ? sanitize_text_field(wp_unslash($_POST['_wpnonce'])) : '';

        if (!wp_verify_nonce($nonce, 'dpdpa_update_request_' . $id)) {
            wp_die(esc_html__('Security check failed.', 'dpdpa-compliance-india'));
        }

        if (!current_user_can('manage_options')) {
            wp_die(esc_html__('Unauthorized access.', 'dpdpa-compliance-india'));
        }

        global $wpdb;
        $requests_table = $wpdb->prefix . 'dpdpa_requests';
        $logs_table = $wpdb->prefix . 'dpdpa_request_logs';

        $action = isset($_POST['dpdpa_action']) ? sanitize_text_field(wp_unslash($_POST['dpdpa_action'])) : '';
        $status = ('complete' === $action) ? 'completed' : 'rejected';

        // Update request status
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $wpdb->update(
            $requests_table,
            ['status' => $status],
            ['id' => $id],
            ['%s'],
            ['%d']
        );

        // Log the action
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $wpdb->insert(
            $logs_table,
            [
                'request_id' => $id,
                'action' => $status,
                /* translators: %s: the status of the request (completed/rejected) */
                'notes' => sprintf(__('Request %s by administrator.', 'dpdpa-compliance-india'), $status),
            ],
            ['%d', '%s', '%s']
        );

        // Redirect back with message
        wp_safe_redirect(add_query_arg(['page' => 'dpdpa-requests', 'action' => 'view', 'id' => $id, 'updated' => 1], admin_url('admin.php')));
        exit;
        exit;
    }
}
