<?php
/**
 * Admin Menu class.
 *
 * @package DPDPA_Compliance_India
 */

namespace DPDPA\Admin;

if (!defined('ABSPATH')) {
    exit;
}

class Menu
{
    public function __construct()
    {
        add_action('admin_menu', [$this, 'register_menu']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_assets']);
    }

    public function enqueue_assets($hook)
    {
        if (false === strpos($hook, 'dpdpa')) {
            return;
        }
        wp_enqueue_style('dpdpa-admin', DPDPA_URL . 'assets/css/admin.css', [], DPDPA_VERSION);
        wp_enqueue_script('dpdpa-admin', DPDPA_URL . 'assets/js/admin.js', ['jquery'], DPDPA_VERSION, true);

        wp_localize_script('dpdpa-admin', 'dpdpa_vars', [
            'nonce' => wp_create_nonce('dpdpa_admin_nonce'),
            'ajaxurl' => admin_url('admin-ajax.php')
        ]);
    }

    public function register_menu()
    {
        add_menu_page(
            __('DPDPA Compliance', 'dpdpa-compliance-india'),
            __('DPDPA', 'dpdpa-compliance-india'),
            'manage_options',
            'dpdpa-dashboard',
            [$this, 'render_dashboard'],
            'dashicons-shield',
            80
        );

        add_submenu_page(
            'dpdpa-dashboard',
            __('Dashboard', 'dpdpa-compliance-india'),
            __('Dashboard', 'dpdpa-compliance-india'),
            'manage_options',
            'dpdpa-dashboard',
            [$this, 'render_dashboard']
        );

        add_submenu_page(
            'dpdpa-dashboard',
            __('DSR Requests', 'dpdpa-compliance-india'),
            __('Requests', 'dpdpa-compliance-india'),
            'manage_options',
            'dpdpa-requests',
            [$this, 'render_requests']
        );

        add_submenu_page(
            'dpdpa-dashboard',
            __('Settings', 'dpdpa-compliance-india'),
            __('Settings', 'dpdpa-compliance-india'),
            'manage_options',
            'dpdpa-settings',
            [$this, 'render_settings']
        );
    }

    public function render_dashboard()
    {
        require_once DPDPA_PATH . 'includes/Admin/views/dashboard.php';
    }

    public function render_requests()
    {
        require_once DPDPA_PATH . 'includes/Admin/views/requests.php';
    }

    public function render_settings()
    {
        require_once DPDPA_PATH . 'includes/Admin/views/settings.php';
    }
}
