<?php
namespace DPDPA\Admin;

if (!defined('ABSPATH')) {
    exit;
}

class Dashboard
{
    public function __construct()
    {
        add_action('admin_enqueue_scripts', [$this, 'enqueue_assets']);
        add_action('wp_ajax_dpdpa_finish_onboarding', [$this, 'finish_onboarding']);
    }

    public function enqueue_assets($hook)
    {
        if ('toplevel_page_dpdpa-dashboard' !== $hook) {
            return;
        }
        // We'll add React scripts here later
    }

    public function finish_onboarding()
    {
        check_ajax_referer('dpdpa_admin_nonce', 'nonce');

        if (!current_user_can('manage_options')) {
            wp_send_json_error('Unauthorized');
        }

        $settings = get_option('dpdpa_settings', []);
        $settings['onboarding_complete'] = true;

        if (isset($_POST['role'])) {
            $settings['site_role'] = sanitize_text_field(wp_unslash($_POST['role']));
        }

        if (isset($_POST['org_name'])) {
            $settings['organization_name'] = sanitize_text_field(wp_unslash($_POST['org_name']));
        }

        if (isset($_POST['dpo_email'])) {
            $settings['dpo_email'] = sanitize_email(wp_unslash($_POST['dpo_email']));
        }

        if (isset($_POST['purposes'])) {
            $purposes = json_decode(wp_unslash($_POST['purposes']), true);
            if (is_array($purposes)) {
                $settings['enabled_purposes'] = array_map('sanitize_text_field', $purposes);
            }
        }

        // Enable banner by default after onboarding
        $settings['enable_banner'] = true;

        update_option('dpdpa_settings', $settings);

        // Generate default legal pages
        $this->generate_default_pages();

        wp_send_json_success();
    }

    private function generate_default_pages()
    {
        // Create Privacy Policy Page if it doesn't exist
        if (!get_page_by_path('privacy-notice')) {
            wp_insert_post([
                'post_title' => 'Privacy Policy (DPDPA)',
                'post_name' => 'privacy-notice',
                'post_content' => '[dpdpa_privacy_notice]',
                'post_status' => 'publish',
                'post_type' => 'page',
            ]);
        }

        // Create Request Form Page
        if (!get_page_by_path('data-subject-requests')) {
            wp_insert_post([
                'post_title' => 'Data Subject Requests',
                'post_name' => 'data-subject-requests',
                'post_content' => '[dpdpa_request_form]',
                'post_status' => 'publish',
                'post_type' => 'page',
            ]);
        }
    }
}
